/*
 * Decompiled with CFR 0.152.
 */
package niki;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.net.URL;
import java.util.Vector;
import niki.Feld;
import niki.GUIKonstanten;
import niki.Niki;
import niki.NikiKonstanten;
import niki.Welt;
import niki.WeltKonstanten;

public class NikiGUI
extends Frame
implements GUIKonstanten,
NikiKonstanten,
WeltKonstanten {
    Welt nikisWelt;
    Vector roboterListe;
    int roboterAnzahl;
    int vorrat;
    int lager;
    Image nbild0;
    Image nbild1;
    Image nbild2;
    Image nbild3;
    Image nbild;
    Image mauer;
    Image hammer;
    Image gelb;
    Image tux;
    Image osx;
    Image win;
    TextField vorratText;
    TextField lagerText;
    TextField positionsText;
    boolean stop;
    boolean run;

    public NikiGUI(Welt welt) {
        super("OOP-Java-Niki,                              Dr.Kokavecz");
        this.resize(780, 580);
        this.nikisWelt = welt;
        this.roboterListe = new Vector();
        this.roboterAnzahl = 0;
        this.stop = true;
        this.run = false;
        String string = "nikibilder/";
        URL uRL = this.getClass().getResource(string + "robi0.gif");
        this.nbild0 = Toolkit.getDefaultToolkit().getImage(uRL);
        uRL = this.getClass().getResource(string + "robi1.gif");
        this.nbild1 = Toolkit.getDefaultToolkit().getImage(uRL);
        uRL = this.getClass().getResource(string + "robi2.gif");
        this.nbild2 = Toolkit.getDefaultToolkit().getImage(uRL);
        uRL = this.getClass().getResource(string + "robi3.gif");
        this.nbild3 = Toolkit.getDefaultToolkit().getImage(uRL);
        uRL = this.getClass().getResource(string + "mauer.gif");
        this.mauer = Toolkit.getDefaultToolkit().getImage(uRL);
        uRL = this.getClass().getResource(string + "hammer.gif");
        this.hammer = Toolkit.getDefaultToolkit().getImage(uRL);
        uRL = this.getClass().getResource(string + "gelb.gif");
        this.gelb = Toolkit.getDefaultToolkit().getImage(uRL);
        uRL = this.getClass().getResource(string + "tux.gif");
        this.tux = Toolkit.getDefaultToolkit().getImage(uRL);
        uRL = this.getClass().getResource(string + "osx.gif");
        this.osx = Toolkit.getDefaultToolkit().getImage(uRL);
        uRL = this.getClass().getResource(string + "win.gif");
        this.win = Toolkit.getDefaultToolkit().getImage(uRL);
        Button button = new Button("Single Step");
        Button button2 = new Button("R U N");
        Button button3 = new Button("E X I T");
        Panel panel = new Panel();
        Label label = new Label("");
        Label label2 = new Label("      NIKI JAVA GUI      ");
        this.vorratText = new TextField();
        this.vorratText.setEditable(false);
        this.lagerText = new TextField();
        this.lagerText.setEditable(false);
        this.positionsText = new TextField();
        this.positionsText.setEditable(false);
        panel.setLayout(new GridLayout(11, 1, 1, 14));
        panel.add(label);
        panel.add(label2);
        panel.add(label);
        panel.add(this.vorratText);
        panel.add(this.lagerText);
        panel.add(this.positionsText);
        panel.add(label);
        panel.add(button);
        panel.add(button2);
        panel.add(button3);
        this.setLayout((LayoutManager)new BorderLayout());
        this.add("East", (Component)panel);
        this.show();
    }

    public void statusTextErmitteln(Object object) {
        Niki niki = (Niki)object;
        this.vorrat = niki.getVorrat();
        this.vorratText.setText("Vorrat: " + this.vorrat);
        int n = niki.getXPosition();
        int n2 = niki.getYPosition();
        this.lager = this.nikisWelt.getFeld(n, n2).getWerkzeugAnzahl();
        this.lagerText.setText("Lager: " + this.lager);
        this.positionsText.setText("(X;Y) = ( " + n + " ; " + n2 + " )");
    }

    public void aktualisieren(int n, Object object) {
        Graphics graphics = this.getGraphics();
        switch (n) {
            case 0: {
                this.roboterListe.addElement(object);
                ++this.roboterAnzahl;
                this.paintRoboter(graphics);
                this.statusTextErmitteln(object);
            }
            case 1: {
                Niki niki = (Niki)object;
                int n2 = niki.getXPosition();
                int n3 = niki.getYPosition();
                switch (niki.getRichtung()) {
                    case 0: {
                        if (n2 <= 0) break;
                        --n2;
                        break;
                    }
                    case 1: {
                        ++n3;
                        break;
                    }
                    case 2: {
                        ++n2;
                        break;
                    }
                    case 3: {
                        --n3;
                    }
                }
                Feld feld = this.nikisWelt.getFeld(n2, n3);
                this.nbild = feld.getWerkzeugAnzahl() == 0 ? this.gelb : this.hammer;
                n2 = 11 + 35 * n2;
                n3 = 31 + 35 * n3;
                graphics.drawImage(this.nbild, n2, n3, 34, 34, (ImageObserver)this);
                this.paintRoboter(graphics);
                this.statusTextErmitteln(object);
            }
            case 2: {
                this.paintRoboter(graphics);
                this.statusTextErmitteln(object);
            }
        }
        while (this.stop) {
            this.pause(200);
        }
        if (!this.run) {
            this.stop = true;
        } else {
            this.pause(150);
        }
    }

    public void paint(Graphics graphics) {
        this.paintFelder(graphics);
        graphics.drawImage(this.tux, 10, 536, 34, 34, (ImageObserver)this);
        this.paintHindernis(graphics);
        graphics.drawImage(this.osx, 54, 536, 34, 34, (ImageObserver)this);
        this.paintRoboter(graphics);
        graphics.drawImage(this.win, 98, 536, 34, 34, (ImageObserver)this);
        graphics.setFont(new Font("SansSerif", 1, 14));
        graphics.drawString("FB Informatik, Humboldtschule Berlin-Tegel", 180, 563);
    }

    public void paintRoboter(Graphics graphics) {
        for (int i = 0; i < this.roboterAnzahl; ++i) {
            Niki niki = (Niki)this.roboterListe.elementAt(i);
            switch (niki.getRichtung()) {
                case 0: {
                    this.nbild = this.nbild0;
                    break;
                }
                case 1: {
                    this.nbild = this.nbild1;
                    break;
                }
                case 2: {
                    this.nbild = this.nbild2;
                    break;
                }
                case 3: {
                    this.nbild = this.nbild3;
                }
            }
            int n = 11 + 35 * niki.getXPosition();
            int n2 = 31 + 35 * niki.getYPosition();
            graphics.drawImage(this.nbild, n, n2, 34, 34, (ImageObserver)this);
        }
    }

    private void paintFelder(Graphics graphics) {
        int n;
        graphics.setColor(Color.yellow);
        graphics.fillRect(10, 30, 595, 490);
        graphics.setColor(Color.black);
        graphics.drawRect(10, 30, 595, 490);
        Toolkit.getDefaultToolkit().sync();
        for (n = 0; n < 14; ++n) {
            graphics.drawLine(10, 30 + 35 * n, 605, 30 + 35 * n);
        }
        for (n = 0; n < 17; ++n) {
            graphics.drawLine(10 + 35 * n, 30, 10 + 35 * n, 520);
        }
    }

    private void paintHindernis(Graphics graphics) {
        for (int i = 0; i < 17; ++i) {
            for (int j = 0; j < 14; ++j) {
                int n = 11 + 35 * i;
                int n2 = 31 + 35 * j;
                Feld feld = this.nikisWelt.getFeld(i, j);
                if (feld.istMauer()) {
                    this.nbild = this.mauer;
                    graphics.drawImage(this.nbild, n, n2, 34, 34, (ImageObserver)this);
                    continue;
                }
                if (feld.getWerkzeugAnzahl() <= 0) continue;
                this.nbild = this.hammer;
                graphics.drawImage(this.nbild, n, n2, 34, 34, (ImageObserver)this);
            }
        }
    }

    public void pause(int n) {
        try {
            Thread.currentThread();
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            System.out.println("trallala");
        }
    }

    public boolean handleEvent(Event event) {
        switch (event.id) {
            case 201: {
                System.exit(0);
                return true;
            }
        }
        return super.handleEvent(event);
    }

    public boolean action(Event event, Object object) {
        if ("Single Step".equals(object)) {
            this.stop = false;
            this.run = false;
        } else if ("R U N".equals(object)) {
            this.stop = false;
            this.run = true;
        } else if ("E X I T".equals(object)) {
            System.exit(0);
        }
        return super.action(event, object);
    }
}

