/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.Toolkit;
import java.net.URL;
import java.util.Vector;

public class NikiGUI
extends Frame
implements GUIKonstanten,
NikiKonstanten,
WeltKonstanten {
    Welt nikisWelt;
    Vector roboterListe;
    int roboterAnzahl;
    int vorrat;
    int lager;
    String pfad;
    int modus = 0;
    Feld[][] matrix;
    Image nbild0;
    Image nbild1;
    Image nbild2;
    Image nbild3;
    Image nbild;
    Image mauer;
    Image hammer;
    Image gelb;
    Image tux;
    Image osx;
    Image win;
    TextField vorratText;
    TextField lagerText;
    TextField positionsText;

    public NikiGUI(Welt welt, Feld[][] feldArray) {
        super("OOP-Java-Niki,                              Dr.Kokavecz");
        this.resize(780, 580);
        this.nikisWelt = welt;
        this.matrix = feldArray;
        this.roboterListe = new Vector();
        this.roboterAnzahl = 0;
        this.pfad = "nikibilder/";
        URL uRL = this.getClass().getResource(this.pfad + "robi0.gif");
        this.nbild0 = Toolkit.getDefaultToolkit().getImage(uRL);
        uRL = this.getClass().getResource(this.pfad + "robi1.gif");
        this.nbild1 = Toolkit.getDefaultToolkit().getImage(uRL);
        uRL = this.getClass().getResource(this.pfad + "robi2.gif");
        this.nbild2 = Toolkit.getDefaultToolkit().getImage(uRL);
        uRL = this.getClass().getResource(this.pfad + "robi3.gif");
        this.nbild3 = Toolkit.getDefaultToolkit().getImage(uRL);
        uRL = this.getClass().getResource(this.pfad + "mauer.gif");
        this.mauer = Toolkit.getDefaultToolkit().getImage(uRL);
        uRL = this.getClass().getResource(this.pfad + "hammer.gif");
        this.hammer = Toolkit.getDefaultToolkit().getImage(uRL);
        uRL = this.getClass().getResource(this.pfad + "gelb.gif");
        this.gelb = Toolkit.getDefaultToolkit().getImage(uRL);
        uRL = this.getClass().getResource(this.pfad + "tux.gif");
        this.tux = Toolkit.getDefaultToolkit().getImage(uRL);
        uRL = this.getClass().getResource(this.pfad + "osx.gif");
        this.osx = Toolkit.getDefaultToolkit().getImage(uRL);
        uRL = this.getClass().getResource(this.pfad + "win.gif");
        this.win = Toolkit.getDefaultToolkit().getImage(uRL);
        Button button = new Button("clear");
        Button button2 = new Button("store world");
        Button button3 = new Button("README");
        Button button4 = new Button("E X I T");
        Button button5 = new Button("wall");
        Button button6 = new Button("tools+");
        Button button7 = new Button("tools-");
        Panel panel = new Panel();
        Label label = new Label("");
        Label label2 = new Label("      NIKI World Editor      ");
        this.vorratText = new TextField();
        this.vorratText.setEditable(false);
        this.lagerText = new TextField();
        this.lagerText.setEditable(false);
        this.positionsText = new TextField();
        this.positionsText.setEditable(false);
        panel.setLayout(new GridLayout(10, 1, 1, 18));
        panel.add(label2);
        panel.add(label);
        panel.add(button);
        panel.add(button5);
        panel.add(button6);
        panel.add(button7);
        panel.add(button2);
        panel.add(label);
        panel.add(label);
        panel.add(button4);
        this.setLayout(new BorderLayout());
        this.add((Component)panel, "East");
        this.setVisible(true);
        this.show();
    }

    private void clearFeld() {
        for (int i = 0; i < 17; ++i) {
            for (int j = 0; j < 14; ++j) {
                this.matrix[i][j].switchMauer();
                this.matrix[i][j].switchMauer();
                if (!this.matrix[i][j].istMauer()) continue;
                this.matrix[i][j].switchMauer();
            }
        }
    }

    private void statusTextErmitteln(Object object) {
        Niki niki = (Niki)object;
        this.vorrat = niki.getVorrat();
        this.vorratText.setText("Vorrat: " + this.vorrat);
        int n = niki.getXPosition();
        int n2 = niki.getYPosition();
        this.lager = this.nikisWelt.getFeld(n, n2).getWerkzeugAnzahl();
        this.lagerText.setText("Lager: " + this.lager);
        this.positionsText.setText("(X;Y) = ( " + n + " ; " + n2 + " )");
    }

    public void aktualisieren(int n, Object object) {
        Graphics graphics = this.getGraphics();
        Niki niki = (Niki)object;
        switch (n) {
            case 0: {
                this.roboterListe.addElement(object);
                ++this.roboterAnzahl;
            }
            case 1: {
                int n2 = niki.getXPosition();
                int n3 = niki.getYPosition();
                switch (niki.getRichtung()) {
                    case 0: {
                        if (n2 <= 0) break;
                        --n2;
                        break;
                    }
                    case 1: {
                        ++n3;
                        break;
                    }
                    case 2: {
                        ++n2;
                        break;
                    }
                    case 3: {
                        --n3;
                    }
                }
                Feld feld = this.nikisWelt.getFeld(n2, n3);
                this.nbild = feld.getWerkzeugAnzahl() == 0 ? this.gelb : this.hammer;
                n2 = 11 + 35 * n2;
                n3 = 31 + 35 * n3;
                graphics.drawImage(this.nbild, n2, n3, 34, 34, this);
            }
        }
        this.paintRoboter(graphics);
        this.statusTextErmitteln(object);
    }

    public void paint(Graphics graphics) {
        this.paintFelder(graphics);
        graphics.drawImage(this.tux, 10, 531, 39, 39, this);
        this.paintHindernis(graphics);
        graphics.drawImage(this.osx, 59, 531, 39, 39, this);
        graphics.drawImage(this.win, 108, 531, 39, 39, this);
        graphics.setFont(new Font("SansSerif", 1, 14));
        graphics.drawString("FB Informatik, Humboldtschule Berlin-Tegel", 205, 561);
    }

    public void paintRoboter(Graphics graphics) {
        for (int i = 0; i < this.roboterAnzahl; ++i) {
            Niki niki = (Niki)this.roboterListe.elementAt(i);
            switch (niki.getRichtung()) {
                case 0: {
                    this.nbild = this.nbild0;
                    break;
                }
                case 1: {
                    this.nbild = this.nbild1;
                    break;
                }
                case 2: {
                    this.nbild = this.nbild2;
                    break;
                }
                case 3: {
                    this.nbild = this.nbild3;
                }
            }
            int n = 11 + 35 * niki.getXPosition();
            int n2 = 31 + 35 * niki.getYPosition();
            graphics.drawImage(this.nbild, n, n2, 34, 34, this);
        }
    }

    private void paintFelder(Graphics graphics) {
        int n;
        graphics.setColor(Color.yellow);
        graphics.fillRect(10, 30, 595, 490);
        graphics.setColor(Color.black);
        graphics.drawRect(10, 30, 595, 490);
        Toolkit.getDefaultToolkit().sync();
        for (n = 0; n < 14; ++n) {
            graphics.drawLine(10, 30 + 35 * n, 605, 30 + 35 * n);
        }
        for (n = 0; n < 17; ++n) {
            graphics.drawLine(10 + 35 * n, 30, 10 + 35 * n, 520);
        }
    }

    private void paintHindernis(Graphics graphics) {
        for (int i = 0; i < 17; ++i) {
            for (int j = 0; j < 14; ++j) {
                int n = 11 + 35 * i;
                int n2 = 31 + 35 * j;
                Feld feld = this.nikisWelt.getFeld(i, j);
                if (feld.istMauer()) {
                    this.nbild = this.mauer;
                    graphics.drawImage(this.nbild, n, n2, 34, 34, this);
                    continue;
                }
                if (feld.getWerkzeugAnzahl() <= 0) continue;
                this.nbild = this.hammer;
                graphics.drawImage(this.nbild, n, n2, 34, 34, this);
            }
        }
    }

    public void pause(int n) {
        try {
            Thread.currentThread();
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            System.out.println("trallala");
        }
    }

    public boolean handleEvent(Event event) {
        switch (event.id) {
            case 201: {
                System.exit(0);
                return true;
            }
        }
        return super.handleEvent(event);
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if (n > 10 && n2 > 30 && n < 605 && n2 < 520) {
            n = (n - 10) / 35;
            n2 = (n2 - 30) / 35;
            Feld feld = this.nikisWelt.getFeld(n, n2);
            switch (this.modus) {
                case 0: {
                    feld.switchMauer();
                    break;
                }
                case 1: {
                    feld.setWerkzeugAnzahl(feld.getWerkzeugAnzahl() + 1);
                    break;
                }
                case 2: {
                    feld.setWerkzeugAnzahl(feld.getWerkzeugAnzahl() - 1);
                    if (feld.getWerkzeugAnzahl() >= 0) break;
                    feld.setWerkzeugAnzahl(0);
                }
            }
            Graphics graphics = this.getGraphics();
            int n3 = 11 + 35 * n;
            int n4 = 31 + 35 * n2;
            graphics.drawImage(this.gelb, n3, n4, 34, 34, this);
            this.paintHindernis(graphics);
        }
        return true;
    }

    public boolean action(Event event, Object object) {
        if ("clear".equals(object)) {
            this.clearFeld();
            this.repaint();
        } else if ("wall".equals(object)) {
            this.modus = 0;
        } else if ("tools+".equals(object)) {
            this.modus = 1;
        } else if ("tools-".equals(object)) {
            this.modus = 2;
        } else if ("store world".equals(object)) {
            this.nikisWelt.weltSchreiben();
        } else if ("README".equals(object)) {
            String string = System.getProperty("NIKI");
            ReadMe readMe = new ReadMe(string + "README.txt");
        } else if ("E X I T".equals(object)) {
            System.exit(0);
        }
        return super.action(event, object);
    }
}

