package stiftUndCo;

import java.awt.*;
import java.applet.*;
/**
@author Georg Dick
@version 20.3.99
*/
public class BuntStift extends Stift  implements FarbInterface,
SchriftInterface, MusterInterface
{
  private String zaktuellfont =	STANDARDSCHRIFTART;
  private int zschriftstil=	STANDARDSTIL;
  private int zschriftgroesse=STANDARDGROESSE;
  private Font zschriftart=STANDARDSCHRIFT;
  private Color zfarbe = SCHWARZ;
  private int zlinienbreite=1;	   /* noch ohne Bedeutung, da Java
  keine Breiten unterst&uuml;tzt */
  private int zmuster=DURCHSICHTIG;
  

  public BuntStift(){
	  super();}

  public BuntStift(Malflaeche b){
	  super(b);
  }

  public BuntStift(Graphics g){
	  super(g);
  }

  public void gibFrei(){
	 zschriftart=null;
	 zfarbe = null;
	 super.gibFrei();
  }

  public void setzeFarbe(Color farbe){
   zfarbe=farbe;
  }

  public Color farbe(){
	  return zfarbe;
  }

  public void setzeLinienBreite(int pb){
	  zlinienbreite=pb;
  }

  public void setzeFuellMuster(int muster){
	  zmuster=muster;
  }

  public void setzeSchrift(String art, int stil, int groesse){
	   zaktuellfont=art;
	   zschriftgroesse=groesse;
	   zschriftstil= stil;
  }

  public void setzeSchriftArt(String schriftart){
	zaktuellfont=schriftart;
  zschriftart=null;
  zschriftart=new Font(zaktuellfont,zschriftstil,zschriftgroesse);
  }

  public void setzeSchriftGroesse(int schriftgroesse) {
	 zschriftgroesse=schriftgroesse;
   zschriftart=null;
   zschriftart=new Font(zaktuellfont,zschriftstil,zschriftgroesse);
  }

  public void setzeSchriftStil(int schriftstil) {
	 zschriftstil= schriftstil;
   zschriftart=null;
   zschriftart=new Font(zaktuellfont,zschriftstil,zschriftgroesse);
  }

  public void setzeStandard() {
   zstiftx=0;zstifty=0;	// Stiftposition
   zhoch=true; // Stiftzustand
   zwinkel=0;	// Stiftrichtung
   zschreibmodus=NORMALMODUS; //	  Normalmodus
   zaktuellfont =STANDARDSCHRIFTART;
   zschriftstil=	STANDARDSTIL;
   zschriftgroesse=STANDARDGROESSE;
   zschriftart=STANDARDSCHRIFT;
   zfarbe = SCHWARZ;
   zlinienbreite=1;
   zmuster = DURCHSICHTIG;
  }

  protected void setzeZustand(Graphics g){
	 if ((g!=null)) {
		if (zschreibmodus==NORMALMODUS)
		{
			g.setColor(zfarbe);g.setPaintMode();
		}	else
		if (zschreibmodus==RADIERMODUS)
		{
			g.setColor(bildschirm().hintergrundFarbe());
			g.setPaintMode();
		}	else
		{
			g.setColor(zfarbe);
			g.setXORMode(bildschirm().hintergrundFarbe());
		}


		 g.setFont(zschriftart);

  } else { /* System.out.println("Kein g")*/;}
 }

  public void zeichneKreis(double pradius){
    int x1,y1,d;

    gr=this.g();
    if (gr != null )
    {
      x1=(int)Math.round(zstiftx-pradius);
      y1=(int)Math.round(zstifty-pradius);
      d=(int)Math.round(2*pradius);
      if (zmuster==DURCHSICHTIG)
      {
        setzeZustand(gr);
        gr.drawOval(x1,y1,d,d);
      }
      else
      {	if (zmuster==GEFUELLT)
        {
        setzeZustand(gr);
        gr.fillOval(x1,y1,d,d);
        }
      }
    } else { /* System.out.println("Kein g bei Rechteck") */;}
    gr=null;
  }

  public void zeichneRechteck(double pbreite, double phoehe){
    int x1,y1,x2,y2;
    gr = this.g();
    if (gr != null)
    {
      x1=(int)Math.round(zstiftx);x2=(int)Math.round(pbreite)-1;
      y1=(int)Math.round(zstifty);y2=(int)Math.round(phoehe)-1;
      if (zmuster==DURCHSICHTIG)
      {
          setzeZustand(gr);
          gr.drawRect(x1,y1,x2,y2);
      }
      else
      {		if (zmuster==GEFUELLT)
      {
          setzeZustand(gr);
          gr.fillRect(x1,y1,x2+1,y2+1);
          /* fillrect zeichnet kleinere Rechtecke als drawrect ! */
        }
      }
    }
    gr=null;
  }
}