//import figures.*;

import java.util.*;
import stiftUndCo.*;
import java.awt.*;


public class Ball extends Kreis
{

	private double dir, spd, brad, xk, yk;
	private Bildschirm b;

/**
	 * Konstruktur mit Mittelpunkt, Radius, Richtungswinkel und Geschwindigkeit
	 * 
	 * @param  x   x-Koordinate des Mittelpunktes
	 * @param  y   y-Koordinate des Mittelpunktes
	 * @param  rad   Radius des Balles
	 * @param  richtung   Richtungswinkel in Grad 
	 * @param  geschwindigkeit   Faktor fr Tempo
	 */
public Ball(double x, double y, double rad, double richtung, double geschwindigkeit)
{
	super(x,y,rad); 
    dir = richtung;
	spd = geschwindigkeit;
	xk = x;
	yk = y;

}

/**
	 * Konstruktur mit Mittelpunkt, Radius, Richtungswinkel und Geschwindigkeit
	 * 
	 * @param  x   x-Koordinate des Mittelpunktes
	 * @param  y   y-Koordinate des Mittelpunktes
	 * @param  rad   Radius des Balles
	 * @param  richtung   Richtungswinkel in Grad 
	 * @param  geschwindigkeit   Faktor fr Tempo
	 * @param  b  Bildschirm (aus StiftUndCo)
	 */

public Ball(double x, double y, double rad, double richtung, double geschwindigkeit, Bildschirm b)
{
	super(x,y,rad);

	dir = richtung;
	spd = geschwindigkeit;
	this.b = b;
	xk = x;
	yk = y;

}

/**
	 * Liefert den Richtungswinkel in Grad
	 * 
	 * @return     Richtungswinkel in Grad
	 */
public double getDir()
{
	return(dir);
}


/**
	 * Setzt den Richtungswinkel
	 * 
	 * @param richtung     Richtungswinkel in Grad
	 */
	
public void SetzeRichtung(double richtung)
{
	dir = richtung;
}

/**
	 * Setzt die Geschwindigkeit
	 * 
	 * @param geschwindigkeit    
	 */

public void SetzeGeschwindigkeit(double geschwindigkeit)
{
	spd = geschwindigkeit;
}


/**
	 * Verschiebt den Ball um 1 Einheit in die aktuelle Richtung. 
	 * Falls der Ball auf den Rand trifft, wird
	 * der Richtungswinkel gendert.
	 */

public void bewege()
{
	verschiebe(Hilfe.cosinus(dir)*spd,-Hilfe.sinus(dir)*spd);

	// Abprallen

	if(getX()-getRad() <= 0 || getX()+getRad() >= b.breite())
	{
		dir = 180-dir;
	}

	if(getY()-getRad() <= 0 || getY()+getRad() >= b.hoehe())
	{
		dir = -dir;
	}



}

}
