
package stiftUndCo;

// EreignisApplet.java

import java.awt.*;
import java.applet.Applet;
import java.awt.event.*;

/**
Diese Klasse dient dazu, das Prinzip der EreignisAnwendung auf Applets,
die in eine HTML-Seite eingebettet sind und nicht ber ein Frame realisiert
werden, zu bertragen.
Die Initialisierung des EreignisApplets erfolgt durch &Uuml;berschreiben von initApplet
und nicht ber den Konstruktor.
Ansonsten verfgt ein EreignisApplet &uuml;ber die gleiche Schnittstelle, wie
eine EreignisAnwendung. Code ist also leicht zu &uuml;bertragen.
Die Entwicklung der Klasse befindet sich noch in der Versuchsphase. 

@author Georg Dick
@version 25.8.99

 */
public  class EreignisApplet extends SUMApplet implements Ereignisbearbeitung,
Runnable,KeyListener, MouseListener,MouseMotionListener
{
	private Thread sonstigeEreignisse=null;
  private boolean istMac = System.getProperty("os.name").equals("Mac OS");
	protected SUMApplet bildschirm = null;
	protected Maus maus = null;
	protected Tastatur tastatur = null;
	protected BuntStift stift = null;
	protected int offsetx=0,offsety=0;
	protected boolean appletGestoppt=false;


	/** Methode, die die Initialisierung des abegleiteten Applets 
	enthlt. Die init()-Methode sollte dagegen <b>nicht</b> &uuml;ber-
	schrieben werden. */
	public void initApplet()
	{
	}

	public void stop()
	{
		appletGestoppt=true;
	}

	public boolean appletGestoppt()
	{
		return appletGestoppt;
	}

	public void init ()
	{
	  	super.init();
		this.setVisible(true);
		Hilfe.warte(2000);
		bildschirm=this;
		maus = new Maus(this);
	  tastatur = new Tastatur(this);
		stift = new BuntStift(this);
    offsetx=this.getInsets().left;
		offsety=this.getInsets().top;
    this.bildschirm().setzeEreignisbearbeitung(this);
		this.initApplet();
		this.fuehreAus();
	}
  public synchronized void f\u00fchreAus(){
   this.fuehreAus();
  }
	public synchronized void fuehreAus()
	{
		 	addMouseListener(this);
			addMouseMotionListener(this);
			addKeyListener(this);
			sonstigeEreignisse=new Thread(this); 
			sonstigeEreignisse.start();	
	}

  public  void bearbeiteAndereEreignisse(){}
	public  void bearbeiteMausBewegt(int pWohinH, int pWohinV){}
	public  void bearbeiteMausGezogen(int pWohinH, int pWohinV){}
	public  void bearbeiteMausDruck(int pWoH, int pWoV){}
	public  void bearbeiteMausDruckRechts(int pWoH, int pWoV){}
	public  void bearbeiteMausLos(int pWoH, int pWoV){}
	public  void bearbeiteMausLosRechts(int pWoH, int pWoV){}
	public  void bearbeiteMausKlick(int pWoH, int pWoV){}
	public  void bearbeiteSpezialKlick(int pWoH, int pWoV){}
	public void bearbeiteMausKlickRechts(int pWoH, int pWoV){}
	public void bearbeiteDoppelKlick(int pWoH, int pWoV){}
	public void bearbeiteTaste(char pZeichen){}
	public void bearbeiteFensterBewegt(){}
  public void bearbeiteFensterNeuGezeichnet(){}
	public void beenden()
	{
		this.gibFrei();
	}
	public SUMApplet bildschirm()
	{
		return bildschirm;
	}
	public void gibFrei()
	{	
		if (maus !=null) 
		{
			maus.gibFrei();
			maus=null;
		}
		if (tastatur != null) 
		{
			tastatur.gibFrei();
			tastatur=null;
		}
		if (stift !=null) 
		{
			stift.gibFrei();
			stift= null;
		}
		if (sonstigeEreignisse != null)
		{   
			sonstigeEreignisse.stop();
			sonstigeEreignisse=null;
		}
		super.gibFrei();	
		
	}
	
	public Maus maus()
	{
		return maus;
	}


	public BuntStift stift()
	{
		return stift;
	}
	public Tastatur tastatur()
	{
		return tastatur;
	}

	
	
	
	public void run()
	{
		
	 while (true){
				 try 
			{
				this.bearbeiteAndereEreignisse();
			}
			catch (Exception e)
			{;}
		

		  try
		{
			sonstigeEreignisse.sleep(30);
		}
		catch (Exception e)
		{
		 sonstigeEreignisse.stop();
		}
		}
	}
	

    public void keyTyped(KeyEvent e)
	{}
	public void keyPressed(KeyEvent e)
	{ // Hier gegebenenfalls Puffer aufbauen !
	  char aktuellesZeichen= e.getKeyChar();

	 /*if ((aktuellesZeichen==KeyEvent.CHAR_UNDEFINED)
		 && (e.getKeyCode() != KeyEvent.VK_UNDEFINED))
	 {*/	  
		 switch (e.getKeyCode())
		 {
	      case 27:aktuellesZeichen=Zeichen.ESC;break;
	      case KeyEvent.VK_DOWN:aktuellesZeichen=Zeichen.PFEILUNTEN;break;	 
	      case KeyEvent.VK_END: aktuellesZeichen=Zeichen.ENDE	;break;
	      case KeyEvent.VK_F1: aktuellesZeichen=Zeichen.F1	;break;
	      case KeyEvent.VK_F2: aktuellesZeichen=Zeichen.F2	;break;
	      case KeyEvent.VK_F3: aktuellesZeichen=Zeichen.F3	;break;
	      case KeyEvent.VK_F4: aktuellesZeichen=Zeichen.F4	;break;
	      case KeyEvent.VK_F5: aktuellesZeichen=Zeichen.F5	;break;
	      case KeyEvent.VK_F6: aktuellesZeichen=Zeichen.F6	;break;
	      case KeyEvent.VK_F7: aktuellesZeichen=Zeichen.F7	;break;
	      case KeyEvent.VK_F8: aktuellesZeichen=Zeichen.F8	;break;
	      case KeyEvent.VK_F9: aktuellesZeichen=Zeichen.F9	;break;
	      case KeyEvent.VK_F10: aktuellesZeichen=Zeichen.F10	;break;
	      case KeyEvent.VK_F11: aktuellesZeichen=Zeichen.F11	;break;
	      case KeyEvent.VK_F12: aktuellesZeichen=Zeichen.F12	;break;
	      case KeyEvent.VK_HOME:aktuellesZeichen=Zeichen.POS1;break;	
	      case KeyEvent.VK_LEFT:aktuellesZeichen=Zeichen.PFEILLINKS;break;	
	      case KeyEvent.VK_PAGE_DOWN:aktuellesZeichen=Zeichen.BILDUNTEN;break;	
	      case KeyEvent.VK_PAGE_UP:aktuellesZeichen=Zeichen.BILDAUF;break;	
	      case KeyEvent.VK_RIGHT:aktuellesZeichen=Zeichen.PFEILRECHTS;break;	
	      case KeyEvent.VK_UP:aktuellesZeichen=Zeichen.PFEILOBEN;break;
		}
		 this.bearbeiteTaste(aktuellesZeichen);	
	}

    
    public void keyReleased(KeyEvent e){}
    
    public void mouseClicked(MouseEvent e){
		  if (! e.isMetaDown() ) {
			if (e.getClickCount()>1) {
				this.bearbeiteDoppelKlick(e.getX()-offsetx,e.getY()-offsety);
				if (istMac) this.bearbeiteSpezialKlick(e.getX()-offsetx,e.getY()-offsety);
				}
			else this.bearbeiteMausKlick(e.getX()-offsetx,e.getY()-offsety);}
		else
			{this.bearbeiteMausKlickRechts(e.getX()-offsetx,e.getY()-offsety);
			 this.bearbeiteSpezialKlick(e.getX()-offsetx,e.getY()-offsety);}
	}
    public void mousePressed(MouseEvent e){
		if (! e.isMetaDown() )
		{ this.bearbeiteMausDruck(e.getX()-offsetx,e.getY()-offsety);}
		else
		{ this.bearbeiteMausDruckRechts(e.getX()-offsetx,e.getY()-offsety);}
	}
 
     public void mouseReleased(MouseEvent e){
 		if (! e.isMetaDown() )
		{ this.bearbeiteMausLos(e.getX()-offsetx,e.getY()-offsety);
		}
		else
		{ this.bearbeiteMausLosRechts(e.getX()-offsetx,e.getY()-offsety);}
	}
   public void mouseEntered(MouseEvent e){}
    public void mouseExited(MouseEvent e){}
    public void mouseDragged(MouseEvent e){
	  this.bearbeiteMausBewegt(e.getX()-offsetx,e.getY()-offsety);
	  this.bearbeiteMausGezogen(e.getX()-offsetx,e.getY()-offsety);

	}
    public void mouseMoved(MouseEvent e){
	this.bearbeiteMausBewegt(e.getX()-offsetx,e.getY()-offsety);
	}


  }