
package stiftUndCo;

import java.awt.*;
import java.applet.*;
import java.awt.event.*;
import java.util.*;

/**
Die Klasse Maus erlaubt den Zugriff auf Mauszust&auml;nde. Jedes Mausobjekt ist
an einen Bildschirm oder ein von java.awt.Component abgeleitetes Objekt
gebunden.
@author Georg Dick  Erg&auml;nzung f&uml;r MAC: Horst Hildebrecht
@version 22.7.98

 */
public class Maus implements MouseListener,MouseMotionListener
{
	private int xpos,ypos;
	private int offsetx=0,offsety=0;
	private boolean linksunten=false,rechtsunten=false, doppelt=false;
  private boolean istMac = System.getProperty("os.name").equals("Mac OS");

	public void init(){;}
	public Maus(){
		if (DasFenster.hauptFenster != null)
		{	
			Container b=((Container)(DasFenster.hauptFenster));
			offsetx=b.getInsets().left;
			offsety=b.getInsets().top;
			b.addMouseListener(this);
			b.addMouseMotionListener(this);
			b=null;
		}
	
	}
	public Maus(Component pb)
	{
		pb.addMouseListener(this);
		pb.addMouseMotionListener(this);

	}
  public boolean spezialKlick()
	{
		if (istMac) 
		{return doppelt;}
		else 
		{return rechtsunten;}
	}
	public Maus(Component pb,int ox, int oy)
	{
		pb.addMouseListener(this);
		pb.addMouseMotionListener(this);
		offsetx=ox;
		offsety=oy;

	}
	public void gibFrei()
	{
	
	}
	public int hPosition()
	{
		return xpos-offsetx;
	}
	public boolean istGedrueckt()
	{
		return linksunten;
	}
	public boolean istRechtsGedrueckt()
	{
		return rechtsunten;
	}
	public boolean istGedr\u00fcckt()
	{
		return istGedrueckt();
	}
	public boolean istRechtsGedr\u00fcckt()
	{
		return istRechtsGedrueckt();
	}

public void mouseClicked(MouseEvent  e) {
	xpos = e.getX();
	ypos = e.getY();
	linksunten=false;
	rechtsunten=false;	
}


public void mouseDragged(MouseEvent e) {
	xpos = e.getX();
	ypos = e.getY();
	linksunten=! e.isMetaDown();
	rechtsunten=e.isMetaDown();	
}


public void mouseEntered(MouseEvent e) {
	xpos = e.getX();
	ypos = e.getY();
}	

public void mouseExited(MouseEvent e) {
	xpos = e.getX();
	ypos = e.getY();
}

public void mouseMoved(MouseEvent e) {
	xpos = e.getX();
	ypos = e.getY();
}

public void mousePressed(MouseEvent e) {
	xpos = e.getX();
	ypos = e.getY();
	linksunten=! e.isMetaDown();
	rechtsunten=e.isMetaDown();	
}

public void mouseReleased(MouseEvent e) {
	xpos = e.getX();
	ypos = e.getY();
	linksunten=false;
	rechtsunten=false;	
}

public int vPosition()
	{
	   return ypos-offsety;
	}
}