package stiftUndCo;

import java.awt.*;
import java.applet.*;
import java.awt.event.*;
import java.awt.AWTEvent.*;

/**
 Ein SUMApplet ist das Modell eines rechteckigen Bereiches auf dem
 angeschlossenen Computerbildschirm.
 Auf ihm kann mit Stiften gezeichnet werden. Zu diesem Zweck ist die 
 Zeichenebene auf dem Bildschirm mit einem Koordinatensystem versehen, 
 dessen Ursprung sich in der oberen linken Ecke der Zeichenebene befindet
 und dessen Achsen horizontal nach rechts und vertikal nach unten 
 gerichtet sind. Die Einheit ist ein Pixel.
 Die Implementierung enth&auml;lt einige Zus&auml;tze zum Standard der Stifte und M&auml;use,
 etwa die M&ouml;glichkeit f&uuml;r double-buffering.

 @author Georg Dick
 @version 12.8.99

  */
public class SUMApplet extends Applet implements MalFenster
{
	
	//public static MalFenster hauptbildschirm=null;
	private Color zhintergrundfarbe=Farbe.HELLGRAU;
	private int zhoehe=0,zbreite=0;
	protected Graphics grafikKontext=null;
	protected Graphics hggrafikkontext=null;
	protected Image hintergrundbild=createImage(1,1);
	protected boolean zhintergrundmodus=false;
  protected Ereignisbearbeitung meineEreignisbearbeitung=null;
	

	public void info(String s)
	{
		System.out.println(s);
	}

	public void init() 
	{
	  super.init();
	  //addComponentListener(this);
	  this.setLayout(new FlowLayout());
	  this.setBackground(zhintergrundfarbe);
	  zbreite=getSize().width;
	  zhoehe=getSize().height;
	  grafikKontext.translate(this.getInsets().left,this.getInsets().top);
	  zhintergrundmodus=false;  
	  this.registriere();
	  this.requestFocus();
	  hintergrundbild = createImage(getSize().width,getSize().height);
	  
	}



	/** Macht einen Grafikkontext f&uuml;r dieses Rechteck dauerhaft(!) verf&uuml;gbar.
	Auch auerhalb von paint! */
	public synchronized void addNotify()
	{
		super.addNotify();
		grafikKontext = this.getGraphics();
		
	}

	/**
	Das Hintergrundbild wird angezeigt
	@see Bildschirm#setzeHintergrundmodus
	*/
	public void aktualisiere()
	{
		if (zhintergrundmodus)
		{
		    grafikKontext.drawImage(hintergrundbild,0,0,this);
		}
	}
	
	/**
	stellt einen Grafikkontext f&uuml;r Malwerkzeuge, wie den Stift,
	zur Verf&uuml;gung. 
	*/

	public Graphics aktuellerGrafikkontext()
	{
		if (zhintergrundmodus)
		{
		     return hggrafikkontext;
		} else
		{

			return grafikKontext; 
		}
	}

	/**
	liefert den Wert wahr, wenn double-buffering benutzt wird
	*/
	public boolean hintergrundmodus()
	{ 
		return zhintergrundmodus;
	}
    

	/**
	Anfrage	breite() liefert die Breite der Zeichenebene.
	*/
	public int breite()
	{
		return this.getSize().width-getInsets().left-getInsets().right;
	}
	
	protected Graphics g() {
	 return grafikKontext;
	}
	/**
	das Fenster wird abgebaut
	*/
	public void gibFrei()
	{
		this.setVisible(false);
		if (this == DasFenster.hauptFenster) 
		{
			DasFenster.hauptFenster=null;
		}	
		zhintergrundfarbe=null;
		grafikKontext=null;
		hggrafikkontext=null;
		hintergrundbild=null;
	     
	}
	/**
	Anfrage	hintergrundFarbe() liefert die Farbe des Hintergrundes
	*/
	public Color hintergrundFarbe()
	{
		return zhintergrundfarbe ;
	}
	/**
	Anfrage	hoehe()  liefert die H&ouml;he der Zeichenebene.
	*/
	public int hoehe()
	{
	   	return this.getSize().height-getInsets().top-getInsets().bottom;
	}
	/**
	Auftrag	loescheAlles() <br>
	nachher:	Die Zeichenebene ist leer.
	*/

  public int h\u00f6he()
  {
    return this.hoehe();
  }
	public void loescheAlles()
	{ 		 
		if ( ! zhintergrundmodus)
		{
			grafikKontext.setColor(zhintergrundfarbe);
			grafikKontext.fillRect(0,0,getSize().width,getSize().height);
		} else
		{

			hggrafikkontext.setColor(zhintergrundfarbe);
			hggrafikkontext.fillRect(0,0,getSize().width,getSize().height);
			grafikKontext.drawImage(hintergrundbild,0,0,this);
		}
	}
   /**
	Auftrag	l&ouml;scheAlles() <br>
	nachher:	Die Zeichenebene ist leer.
	*/
  public  void l\u00f6scheAlles(){
   this.loescheAlles();
  }
 
	/**
	Der erste Bildschirm, den eine Anwendung erzeugt wird als Klassenobjekt
	gespeichert
	@see#hauptbildschirm
	*/
	private void registriere(){
		if (DasFenster.hauptFenster==null) {DasFenster.hauptFenster=this;}
	}
	/**
	Beim Abbau des Fensters wird der Grafikkontext wieder freigegeben
	*/
	public synchronized void removeNotify()
	{
		super.removeNotify();
		grafikKontext = null;
	}
	/**
	Auftrag	setzeHintergrundFarbe(Color c) <br>
	nachher	Der Bildschirm hat die angegebene Hintergrundfarbe
	*/
	public synchronized void setzeHintergrundFarbe(Color c) 
	{
		zhintergrundfarbe=c;
		if ( ! zhintergrundmodus)
		{
			this.setBackground(zhintergrundfarbe);
			//this.setSize(this.getSize().width-1,this.getSize().height-1);
			//this.setSize(this.getSize().width+1,this.getSize().height+1);
		} else
		{
			hggrafikkontext.setColor(zhintergrundfarbe);
			hggrafikkontext.fillRect(0,0,getSize().width,getSize().height);
			grafikKontext.drawImage(hintergrundbild,0,0,this);
			
		}
		Hilfe.warte(2000);
	}
	/**
	Schaltet double-Buffering ein oder aus. Bei eingeschaltetem 
	Hintergrundmodus werden alle Zeichenoperationen unsichtbar 
	auf ein Hintergrundbild angewendet.
	Sie werden erst sichtbar, wenn der Bildschirm aktualisiert wird.
	@see Bildschirm#aktualisiere()
	*/
	public void setzeHintergrundmodus(boolean ein)
	{
		if (ein)
		{
			// neues Hintergrundbild erzeugen
			hggrafikkontext= hintergrundbild.getGraphics();
			this.setzeHintergrundFarbe(zhintergrundfarbe);
		}
		else
		{
			if (hintergrundbild != null)
			grafikKontext.drawImage(hintergrundbild,0,0,this);
			hintergrundbild=null;
		}
		zhintergrundmodus=ein;
	}

	public void update (Graphics g)
	{
		//info("update");
	//	this.paint(g);
	}

  public void paint(Graphics g){
    super.paint(g);
    if ( this.meineEreignisbearbeitung != null ){
     this.meineEreignisbearbeitung.bearbeiteFensterNeuGezeichnet();
    }
  }
		/**
	pat den Fensterinhalt an, wenn das Fenster bewegt wurde 
	oder die Gr&ouml;e sich ge&auml;ndert hat. Die Methode ist noch nicht 
	"fertig".
	*/
	public void bearbeiteFensterver\u00e4ndert()
	{

		if (zhintergrundmodus)
		{
			Image hilf=createImage(getSize().width,getSize().height);
			hilf.getGraphics().drawImage(hintergrundbild,0,0,this);
			hintergrundbild=null;
			hggrafikkontext= null;
			System.gc();
			hintergrundbild=hilf;
			hggrafikkontext= hintergrundbild.getGraphics();
			hilf=null;
		}
	}
  public  void bearbeiteFensterveraendert(){
     this.bearbeiteFensterver\u00e4ndert();
  }
  /*
	public void componentShown(ComponentEvent e){
		//info ("Cshow");
	}
	public void componentResized(ComponentEvent e)
	{
		//info("CResized")		;
		bearbeiteFensterver\u00e4ndert();
	}
	public void componentHidden(ComponentEvent e)
	{   //info("CHidden")		;
		
	}
	public void componentMoved(ComponentEvent e)
	{  //info("CMoved");
		bearbeiteFensterver\u00e4ndert();
	}

  */
	 protected void setzeEreignisbearbeitung(Ereignisbearbeitung eab){
    this.meineEreignisbearbeitung  = eab;
  }
}