 
import stiftUndCo.*;
import java.awt.*;

/**
 * Ein Kreis wird durch den Mittelpunkt und den Radius festgelegt.
 *
 * @author Kai Christoph Meier
 * @version 1.0  (1. Mrz 2004)
 */

public class Kreis extends Figur
{
   // Variablendeklaration
   
   boolean gefuellt;

   // benutzte Objekte
   private BuntStift meinStift;
   private Bildschirm b;

   /* die Attribute aus der abstrakten Oberklasse Figur sind in der Unterklasse
     Linie implizit bekannt, es werden nur zusaetzliche Attribute deklariert */
   private double rad,x1,y1;
   private Color fuellfarbe, linienfarbe;


  /** Konstruktur : Erzeugt einen Kreis mit dem in der Parameterliste
    * angegebenen Mittelpunkt und Radius. Der Kreis wird von einem Stift verwaltet.
    */

   public Kreis(double x1_koord, double y1_koord, double r)
    {
      // Erzeugen des Buntstiftes
      
      if (DasFenster.hauptFenster == null)
        b = new Bildschirm();
      meinStift = new BuntStift();

      // Initialisierung der Zustandsvariablen
      x1 = x1_koord;
      y1 = y1_koord;
      rad = r;

    } // Ende Konstruktor

    
    /**
	 * Liefert die x-Koordinate des Kreismittelpunktes.
	 * 
	 * @return     die x-Koordinate des Kreismittelpunktes
	 */
      public double getX()
      {
        return(x1);
      }

    /**
	 * Liefert die y-Koordinate des Kreismittelpunktes.
	 * 
	 * @return     die y-Koordinate des Kreismittelpunktes
	 */
      public double getY()
      {
        return(y1);
      }

      /**
	 * Liefert den Radius des Kreises
	 * 
	 * @return     den Radius des Kreises
	 */ 
      public double getRad()
      {
        return(rad);
      }

      public void setzeLinienFarbe(Color c)
      {
          meinStift.setzeFarbe(c);
          linienfarbe = c;
      }
      
      public void setzeFuellFarbe(Color c)
      {
         gefuellt=true;
         fuellfarbe = c;
      }

        public void setzeLinienBreite(int lb)
        {
           meinStift.setzeLinienBreite(lb);
        }

    /**
	 *
	 * Zeichnet den aktuellen Kreis auf dem Bildschirm
	 */
        public void zeige()
        {
           meinStift.hoch();
           meinStift.bewegeBis(x1,y1);
           meinStift.runter();

           if(gefuellt)
           {
              meinStift.fuelleKreis(rad,fuellfarbe);
            }
            meinStift.zeichneKreis(rad);
       }

       /**
        * 
        *Lscht den aktuellen Kreis vom Bildschirm
	 */
       public void loesche()
       {
         meinStift.radiere();
         zeige();
         meinStift.normal();
       }
       
       /**
	 * Methode verschiebe
	 * 
	 * @param  dx Verschiebung um dx in x-Richtung
	 * @param  dy Verschiebung um dy in y-Richtung
	 */
       public void verschiebe(double dx, double dy)
       {
          loesche();
          x1=x1+dx;
          y1=y1+dy;
          zeige();
        }

     /**
	 * Vergroessere den Kreis
	 * 
	 * @param  a Vergroessere den Radius um a Einheiten
	 */
       public void vergroessern(double a)
       {
          loesche(); 
          rad = rad + a;
          zeige();
         
        }
       
        /**
	 * Strecke den Kreis
	 * 
	 * @param  a Strecke den Kreis um den Faktor a
	 */
        public void strecke (double a)
        {   
            loesche();
            rad = a*rad;
            zeige();
        }
}
