 
/** Hiermit wird das Paket der Klasse Quadrat festgelegt*/
import stiftUndCo.*;
import java.awt.*;

/**
 * Ein Quadrat wird durch einen Punkt und die Lanege der Seite festgelegt
 * @author Martin Jaster
 * @version 1.0  (22. Mrz 2004)
 */

public class Quadrat extends Figur
{
   // Variablendeklaration

   boolean gefuellt;
   // benutzte Objekte
   private BuntStift stift;

   /* die Attribute aus der abstrakten Oberklasse Figur sind in der Unterklasse
     Linie implizit bekannt, es werden nur zusaetzliche Attribute deklariert */
   private double laenge;




  /** Konstruktur : Erzeugt ein Quadrat mit dem in der Parameterliste
    * angegebenen Eckpunkt links oben und Seitenlnge. 
    */

  public Quadrat(double x1_koord, double y1_koord,double l)
    {
      // Erzeugen des Buntstiftes
    stift = new BuntStift();

      // Initialisierung der Zustandsvariablen
    x1 = x1_koord;
    y1 = y1_koord;
    laenge = l;


    } // Ende Konstruktor
/**
	 * Liefert die x-Koordinate des Punktes links oben
	 * 
	 * @return     die x-Koordinate des Punktes links oben
	 */
public double getX1()
   {
       return x1;
   }
 /**
/** Liefert die y-Koordinate des Punktes links oben
	 * 
	 * @return     die y-Koordinate des Punktes links oben
	 */  
   public double getY1()
   {
       return y1;
   }
    
  /**
	 * Liefert die Seitenlnge des Quadrates
	 * 
	 * @return     die Lnge des Quadrates
	 */
   public double getLaenge()
   {
       return laenge;
   }
   
   
    

      /** Hier wird die Linienfarbe festgelegt.*/
        public void setzeLinienFarbe(Color c)
        {
          linienfarbe = c;
          stift.setzeFarbe(linienfarbe);

  }

  /** Hier wird die Fllfarbe festgelegt.*/
        public void setzeFuellFarbe(Color c)
        {
            gefuellt = true;
            fuellfarbe = c;
        }

  /**Hiermit wird die Linienbreite festgelegt*/
       public void setzeLinienBreite(int lb)
       {
    linienbreite = lb;


  //  stift.setzeLinienbreite(linienbreite);
       }

   /** Zeigt das Quadrat mit den aktuellen Eckpunkten.
    * Falls der Modus gefuellt angegeben ist, wird das Rechteck
    * mit der aktuellen Fuellfarbe ausgemalt
    */

       
       public void zeige()
       {
           stift.hoch();
           stift.bewegeBis(x1,y1);
           stift.runter();
           stift.bewegeUm(laenge);
           stift.dreheBis(-90);
           stift.bewegeUm(laenge);
           stift.dreheUm(-90);
           stift.bewegeUm(laenge);
           stift.dreheUm(-90);
           stift.bewegeUm(laenge);
           stift.dreheBis(0);
           stift.hoch();
        

          /** Mit den 4 Eckpunkten kann er das Quadrat mit Farbe fllen und/oder die Linienfarbe festlegen.*/
                if (gefuellt)
                 {

            double xPoints [] = { x1, (x1 + laenge), (x1 + laenge), x1 };
            double yPoints [] = { y1 , y1 , (y1 + laenge), (y1 + laenge) };
             stift.fuellePolygon(xPoints, yPoints, 4, fuellfarbe);

           }

        }

     /** Mit dieser Methode lscht er die vorher gezeichnete Figur.*/
        public void loesche()
        {  stift.radiere();
           zeige();
          stift.normal();

        }



  /** Mit dieser Methode wird das Quadrat verschoben. Zu x1 wird ix addiert und zu y1 wird iy addiert.*/
        public void verschiebe(double ix, double iy)
        {
          loesche();  
          x1 = (x1+ix);
          y1 = (y1+iy);
          zeige();

        }
  /** Damit wird das Quadrat vergrert bzw. gestreckt, indem man a zu der Lnge der Seiten addiert.*/
        public void strecke(double a)
        {
            loesche();
            laenge = (laenge + a);
            zeige();

        }

  /** Mit dieser Methode wird das Quadrat kompett neu mit den gegebenen Angeben erzeugt.*/
        public void setzePosition(double neux1, double neuy1, double neulaenge)
        {
            loesche();
            x1 = neux1;
            y1 = neuy1;
            laenge = neulaenge;
            zeige();
        }


}
