 
import stiftUndCo.*;
import java.awt.*;

/**
 * Ein Rechteck wird durch zwei gegenberliegende  Eckpunkte festgelegt
 *
 * @author Anne Weileder
 * @version 1.0  (22. Mrz 2004)
 */

public class Rechteck extends Figur
{
   // Variablendeklaration

   boolean gefuellt;
   // benutzte Objekte
   private BuntStift stift;

   /* die Attribute aus der abstrakten Oberklasse Figur sind in der Unterklasse
     Linie implizit bekannt, es werden nur zusaetzliche Attribute deklariert */
   private double x1,x2,y1,y2;


private double xPoints[], yPoints[];

  /** Konstruktur : Erzeugt ein Rechteck mit den in der Parameterliste
    * angegebenen Eckpunkten links oben und rechts unten. Das Rechteck wird von einem Stift verwaltet.
    */

  public  Rechteck(double x1_koord, double y1_koord, double x2_koord, double y2_koord)
    {
      // Erzeugen des Buntstiftes
  stift=new BuntStift();

      // Initialisierung der Zustandsvariablen
  x1=x1_koord;
  y1=y1_koord;
  x2=x2_koord;
  y2=y2_koord;




  linienfarbe= Color.RED;
  fuellfarbe= Color.BLUE;
  linienbreite=1;
    } // Ende Konstruktor

    
   public double getX1()
   {
       return x1;
   }
    
   public double getX2()
   {
       return x2;
   }
    
   public double getY1()
   {
       return y1;
   }
   
   public double getY2()
   {
       return y2;
   } 
  /** Setzen die Linienfarbe des Rechtecks auf die angegebene Farbe
    */


      
        public void setzeLinienFarbe(Color c)
        {
          linienfarbe = c;
          stift.setzeFarbe(linienfarbe);
        }


      public void setzeFuellFarbe(Color c)
        {
            fuellfarbe = c;
            gefuellt=true;

        }


       public void setzeLinienBreite(int lb)
       {
  linienbreite=lb;
       }

   /** Zeigt das Rechteck mit den aktuellen Eckpunkten.
    * Falls der Modus gefuellt angegeben ist, wird das Rechteck
    * mit der aktuellen Fuellfarbe ausgemalt
    */
       public void zeige()
       {
           stift.hoch();
           stift.bewegeBis(x1,y1);
           stift.runter();
           stift.bewegeBis(x2,y1);
           stift.bewegeBis(x2,y2);
           stift.bewegeBis(x1,y2);
           stift.bewegeBis(x1,y1);
           stift.hoch();

           if (gefuellt)
           {
              double xPoints[] = {x1,x1,x2,x2};
              double yPoints[] = {y1,y2,y2,y1};
              stift.fuellePolygon (xPoints, yPoints, 4, fuellfarbe);
           }


  
  
  }
  /** Mit dieser Methode lscht er die vorher gezeichnete Figur.*/
        public void loesche()
        {  stift.radiere();
           zeige();
          stift.normal();

        }



        public void verschiebe(double ix, double iy)
        {
            loesche();
            x1=x1+ix;
            x2=x2+ix;
            y1=y1+iy; 
            y2=y2+iy;
            zeige();

        }

        public void strecke(double a)
        {
            loesche();
            x1-=a;
            y1-=a;
            x2+=a;
            y1+=a;    
            x1-=a;
            y2-=a;
            x2+=a;
            y2+=a;
            zeige();
        }
                // zusaetzliche Methoden (Erweiterung)

        public void setzePosition(double neux1, double neuy1, double neux2, double neuy2)
        {
           loesche(); 
           x1=neux1;
           y1=neuy1;
           x2=neux2;
           y2=neuy2;
           zeige();
        }


}
