
package stiftUndCo;

import java.awt.*;
import java.applet.*;

/**
@author Georg Dick
@version 20.3.99
*/

public class Stift 
{
  /** Stiftmodi	als Klassenkonstante */
  public static final int NORMALMODUS=0;
  public static final int RADIERMODUS=1;
  public static final int WECHSELMODUS=2;
  public MiniMalFlaeche mmflaeche;

  public void init(){;}
  /**Ein Stift mu seinen Arbeitsbereich kennen
  von hier bezieht er u.a. den Grafikkontext.
  Der Arbeitsbereich mu das Interface Malflaeche implementieren
  */
  private Malflaeche kenntBi=null; 
  /** Stiftposition */
  protected double zstiftx=0,zstifty=0;
  /** Stiftzustand */
  protected boolean zhoch=true; 
   /** Stiftrichtung */
  protected double zwinkel=0;	
  /** StandardModus ist NORMALMODUS */
  protected  int zschreibmodus=NORMALMODUS;  
  
  protected Graphics gr;
   
  public Stift(){
	if (DasFenster.hauptFenster != null)
		{	
			kenntBi=DasFenster.hauptFenster;			
	} 
   	this.setzeStandard();
  }  

  public Stift(Malflaeche bi) 
  {
	  kenntBi=bi;
   	this.setzeStandard();	
  }  

  public Stift(Graphics g){
    mmflaeche=new MiniMalFlaeche(g);
    kenntBi=mmflaeche;
    this.setzeStandard();
  }

  public void bewegeBis(double px, double py) 
  {
	if (zhoch==false)
	{ 
	   this.zeichneLinie(px,py,zstiftx,zstifty); 	   
	} 
	this.zstiftx=px;
	this.zstifty=py;
  }  
  public void bewegeUm(double pl)
  {
	  double w;
	  double x,y;
	  w = zwinkel*Math.PI/180;
	  x=zstiftx + pl* Math.cos(w);
	  y=zstifty - pl* Math.sin(w);
	  if ( zhoch == false) { zeichneLinie(zstiftx,zstifty,x,y); }
	  zstiftx = x;
	  zstifty = y;
  }
  public Malflaeche	bildschirm () {
   return kenntBi;
  }  
  public void dreheBis(double pw)
  {
  zwinkel= pw;
  while (zwinkel <0) {zwinkel=zwinkel+360;}
  while (zwinkel >=360 ) {zwinkel=zwinkel-360;}
  }  
  public void dreheUm(double pw)
  {
  zwinkel=zwinkel+pw;
  while (zwinkel <0) {zwinkel=zwinkel+360;}
  while (zwinkel >=360 ) {zwinkel=zwinkel-360;}
  }  
  public Graphics g()
  {
	  return kenntBi.aktuellerGrafikkontext();
  }  
  public void gibFrei()
  {
	  kenntBi=null;
	  System.gc();
  }  
  public void hoch ()
  {
	zhoch=true; 
  }  
  public double hPosition()
  {
	  return zstiftx;
  }  
  public void normal ()
  {
	  zschreibmodus=NORMALMODUS;
  }  
  public void radiere () 
  {
	  zschreibmodus=RADIERMODUS;
  }  
  public void runter ()
  {
	zhoch=false;
  }  
   public synchronized void schreibe(char pt)
  {	
	   String s=String.valueOf(pt);
	   this.schreibe(s);
	
   }    
  public void schreibe(String ps)
  {	
	gr=kenntBi.aktuellerGrafikkontext();
	setzeZustand(gr);
	
	if (gr != null) {

	gr.drawString(ps,(int)Math.round(zstiftx),(int)Math.round(zstifty));
	
	//kenntBi.repaint();
	zstiftx=zstiftx+gr.getFontMetrics().stringWidth(ps);
	
	}
	gr = null;
  }  

 public int textBreite(String ps)
  {	
	gr=kenntBi.aktuellerGrafikkontext();
	setzeZustand(gr);
	
	if (gr != null) {
		
		return gr.getFontMetrics().stringWidth(ps);
	
	
	} else {
	
		return 0;
	}
  }  
	public int textHoehe()
  {	
	gr=kenntBi.aktuellerGrafikkontext();
	setzeZustand(gr);
	
	if (gr != null) {
		
		return gr.getFontMetrics().getHeight();
	
	
	} else {
	
		return 0;
	}
  } 

  public int textH\u00f6he()
  {	
		return textHoehe();
	}
 public void setzeStandard()
  {
  zstiftx=0;zstifty=0;	// Stiftposition
  zhoch=true; // Stiftzustand
  zwinkel=0;	// Stiftrichtung
  this.normal(); //	  Normalmodus 
  }
    
  protected void setzeZustand(Graphics grafik)
  {  
	  if (!(grafik==null))
		{
			if (zschreibmodus==RADIERMODUS) 
			{ 
				grafik.setColor(kenntBi.hintergrundFarbe());
				grafik.setPaintMode();
			} else
	 		if (zschreibmodus==NORMALMODUS)
			{
				grafik.setColor(Color.black);
				grafik.setPaintMode(); 
			}  else 
			{ 
				grafik.setColor(Color.black);
				grafik.setXORMode(kenntBi.hintergrundFarbe()); 
			}	
			grafik.setFont(Schrift.STANDARDSCHRIFT);
		}	 
  }  

  public double vPosition()
  {
	  return zstifty;
  }  
  public void wechsle () 
  {
	  zschreibmodus=WECHSELMODUS;
  }  
  public double winkel()
  {
	  return zwinkel;
  }  
public void zeichneKreis(double pradius)
{
	int x1,y1,d;
	gr=kenntBi.aktuellerGrafikkontext();
	x1=(int)Math.round(zstiftx-pradius);
	y1=(int)Math.round(zstifty-pradius);
	d=(int)Math.round(2.*pradius);
	setzeZustand(gr);
	if (gr != null) {

	gr.drawOval(x1,y1,d,d);
	
	}
	gr=null;
}
  public void zeichneLinie(double x1,double y1,double x2,double y2) 
  {
	  Graphics gr=kenntBi.aktuellerGrafikkontext();
	  setzeZustand(gr);
	  if (gr != null) 
	  {
		gr.drawLine((int)Math.round(x1),(int)Math.round(y1),(int)Math.round(x2),(int)Math.round(y2));
	  }
	  gr=null;
  }  
  public void zeichneRechteck(double pbreite, double phoehe)
  {
   int x1,y1,x2,y2;
    Graphics gr=kenntBi.aktuellerGrafikkontext();
    x1=(int)Math.round(zstiftx);x2=(int)Math.round(pbreite)-1;
    y1=(int)Math.round(zstifty);y2=(int)Math.round(phoehe)-1;
    setzeZustand(gr);
    if (gr != null) {
        gr.drawRect(x1,y1,x2,y2);
    }
    gr=null;
 }
}


