import java.lang.*;
import java.lang.Float;
import java.io.* ;

// Dr. Bernd Kokavecz, Berlin Mai 2001

/*
	Provisorische Version fr linux x-term.
        ---------------------------------------
	In der nchsten Version wird die Umgebungsvariable TERM ausgewertet.
	Dann muss jedes Programm, das mit dieser Klasse arbeitet, wie folgt 
	aufgerufen werden:

	java -DTERM=$TERM programmname
	
*/

class Term{

	BufferedReader tastatur = new BufferedReader(
				new InputStreamReader(System.in));
	String term;
	boolean EOF;
	String x;
	int y;

	public Term(){
		term=System.getProperty("TERM");
		EOF=false;
	};

	public void write(String s){
		System.out.print(s);
	};

	public void newLine(){
		System.out.println();
	};

	public String getString(){
                String zeile = null;
                try{
                        zeile= tastatur.readLine();    // Ende, wenn == null   (^D)
                }
                catch (IOException e){
                }
                return zeile;
	}

	public int readInt(){
		y= 0;
		x = getString();
		try {
	       		 y= Integer.parseInt(x);
		}
		catch (Exception e) {
			System.out.println("Integer eingeben!");
			y = readInt();
		}
		return y;
	}

	public float readFloat(){
		float y = 0;
		String x = getString();
		try {
			y =Float.parseFloat(x);
		}
	        catch (Exception e) {
			System.out.println("Float eingeben!");
			y = readFloat();
		}
		return y;
	}



//  Hier muss in Abhngigkeit von $TERM programmiert werden

        public void clear(){
		System.out.print((char)27+"[2J");
	}

        public void gotoXY(int x, int y){
		System.out.print((char)27+"["+y+";"+x+"H");
	}

        public void clearRestOfLine(){
		System.out.print((char)27+"[K");
	}

        public void storeXY(){
		System.out.print((char)27+"[s");
	}

        public void recallXY(){
		System.out.print((char)27+"[u");
	}

	public void color(int n){
                n=30+(n%8);
		System.out.print((char)27+"["+n+"m");
	};

	public void bgColor(int n){
                n=40+(n%8);
		System.out.print((char)27+"["+n+"m");
	};

	public void attrBlink(){
		System.out.print((char)27+"[5m");
        }

	public void attrBold(){
		System.out.print((char)27+"[1m");
        }

	public void attrInvers(){
		System.out.print((char)27+"[7m");
        }

	public void attrOff(){
		System.out.print((char)27+"[0m");
        }

        public void grafOn(){
		System.out.print((char)14);
	}

        public void grafOff(){
		System.out.print((char)15);
	}

	public void grafHorLine(){
		System.out.print((char)113);
	}

	public void grafVerLine(){
		System.out.print((char)120);
	}

	public void grafX(){
		System.out.print((char)110);
	}

	public void grafLbL(){
		System.out.print((char)109);
	}

	public void grafRbL(){
		System.out.print((char)106);
	}

	public void grafRtL(){
		System.out.print((char)107);
	}

	public void grafLtL(){
		System.out.print((char)108);
	}

	public void grafTT(){
		System.out.print((char)119);
	}

	public void grafBT(){
		System.out.print((char)118);
	}

	public void grafLT(){
		System.out.print((char)116);
	}

	public void grafRT(){
		System.out.print((char)117);
	}

}
