package stiftUndCo;
import java.util.*;
import java.lang.System;
/**
Hilfebibliothek
@author Georg Dick
@version 22.7.98
*/
public class Hilfe 
{    
	private static String[] ids = TimeZone.getAvailableIDs(1 * 60 * 60 * 1000);
	/** 
	ganzzahlige Zufallszahl im Intervall [von..bis]
	*/
	public static int zufall(int von, int bis)
	{
		return (int)(Math.random()*(bis-von+1))+von;
	}
	/**
	Verz&ouml;gerung
	@param zeit in Millisekunden
	*/
	public static void warte(long zeit)
	{
		long start=System.currentTimeMillis();
		while (System.currentTimeMillis()-start < zeit) {}
	}
	/**
	Quadratfunktion
	*/
	public static double quadrat(double von)
	{
		return von*von;
	}
	/**
	Wurzelfunktion
	*/
	public static double wurzel(double von)
	{
		if (von >= 0)
		{
		return Math.sqrt(von);
		}
		return -1;
	}
	/**
	aktuelle Stunde
	*/
	public static int stunde()
	{
	
     SimpleTimeZone pdt = new SimpleTimeZone(1 * 60 * 60 * 1000, ids[0]);
            // set up rules for daylight savings time
     pdt.setStartRule(Calendar.APRIL, 1, Calendar.SUNDAY, 2 * 60 * 60 * 1000);
     pdt.setEndRule(Calendar.OCTOBER, -1, Calendar.SUNDAY, 2 * 60 * 60 * 1000);
            // create a GregorianCalendar with the Pacific Daylight time zone
            // and the current date and time
     Calendar calendar = new GregorianCalendar(pdt);
     Date trialTime = new Date();
     calendar.setTime(trialTime);
     
     return calendar.get(Calendar.HOUR_OF_DAY);
    }
	/**
	aktuelle Minute
	*/
	public static int minute()
	{
		SimpleTimeZone pdt = new SimpleTimeZone(1 * 60 * 60 * 1000, ids[0]);
            // set up rules for daylight savings time
     pdt.setStartRule(Calendar.APRIL, 1, Calendar.SUNDAY, 2 * 60 * 60 * 1000);
     pdt.setEndRule(Calendar.OCTOBER, -1, Calendar.SUNDAY, 2 * 60 * 60 * 1000);
            // create a GregorianCalendar with the Pacific Daylight time zone
            // and the current date and time
     Calendar calendar = new GregorianCalendar(pdt);
     Date trialTime = new Date();
     calendar.setTime(trialTime);
     
     
     return calendar.get(Calendar.MINUTE);
     
	}
	/** 
	aktuelle Sekunde
	*/
	public static int sekunde()
	{
		SimpleTimeZone pdt = new SimpleTimeZone(1 * 60 * 60 * 1000, ids[0]);
            // set up rules for daylight savings time
     pdt.setStartRule(Calendar.APRIL, 1, Calendar.SUNDAY, 2 * 60 * 60 * 1000);
     pdt.setEndRule(Calendar.OCTOBER, -1, Calendar.SUNDAY, 2 * 60 * 60 * 1000);
            // create a GregorianCalendar with the Pacific Daylight time zone
            // and the current date and time
     Calendar calendar = new GregorianCalendar(pdt);
     Date trialTime = new Date();
     calendar.setTime(trialTime);
     
     
     return calendar.get(Calendar.SECOND);
     
	}
	/** 
	aktuelle Millisekunde
	*/
	public static int millisekunde()
	{
		SimpleTimeZone pdt = new SimpleTimeZone(1 * 60 * 60 * 1000, ids[0]);
            // set up rules for daylight savings time
     pdt.setStartRule(Calendar.APRIL, 1, Calendar.SUNDAY, 2 * 60 * 60 * 1000);
     pdt.setEndRule(Calendar.OCTOBER, -1, Calendar.SUNDAY, 2 * 60 * 60 * 1000);
            // create a GregorianCalendar with the Pacific Daylight time zone
            // and the current date and time
     Calendar calendar = new GregorianCalendar(pdt);
     Date trialTime = new Date();
     calendar.setTime(trialTime);
     return calendar.get(Calendar.MILLISECOND);
	}
	/** Arcus Cosinus Ergebnis in Grad */
	public static double arccosinus(double a)
	{
		return Math.acos(a)*180/Math.PI;
	}
	/** Arcus Sinus Ergebnis in Grad */
	public static double arcsinus(double a)
	{
		return Math.asin(a)*180/Math.PI;
	}
	/** Arcus Tangens Ergebnis in Grad */
	public static double arctangens(double a)
	{
		return Math.atan(a)*180/Math.PI;
	}

	/** Cosinusfunktion 
	@param Winkel in Grad
	*/
    public static double cosinus(double  a)
	{
		return Math.cos(a*Math.PI/180);
	}   
	/** Exponentialfunktion
	*/
	public static double exp(double  a)
	{
		return Math.exp(a);
	}
	/** Sinusfunktion 
	@param Winkel in Grad
	*/
	public static double sinus(double  a)
	{
		return Math.sin(a*Math.PI/180);
	}

	/** Tangensfunktion 
	@param Winkel in Grad
	*/
    public static double tangens(double  a)
	{
		return Math.tan(a*Math.PI/180);
	}
}

