#! /usr/bin/python

from xterm import * # nur fr Testumgebung
from gzahl import *
import string

class Bruch:
   """
   /* Klasse Bruch stellt Zhler und Nenner und erforderliche Methoden bereit.
   """
   def __init__(self):
      """
      /* Zaehler und Nenner werden aus der Klasse GZahl gebildet
      """
      self.zaehler=GZahl()
      self.nenner=GZahl()

   def setZaehler(self,wert):
      """
      /* setzt den Zhler. Ist wert ein REAL, so werden die Stellen nach dem
      /* Komma abgeschnitten, ist wert ein anderes Objekt, so wird eine
      /* Fehlermeldung ber StdIO ausgegeben (s. Klasse GZahl)
      /* --------------------------------------------------------------------
      /* wert : integer : Wert fr Zhler
      """
      self.zaehler.setWert(wert)

   def setNenner(self,wert):
      """
      /* setzt den Nenner. Ist wert ein REAL, so werden die Stellen nach dem
      /* Komma abgeschnitten, ist wert ein anderes Objekt, so wird eine
      /* Fehlermeldung ber StdIO ausgegeben (s. Klasse GZahl)
      /* --------------------------------------------------------------------
      /* wert : integer : Wert fr Nenner
      """
      self.nenner.setWert(wert)

   def getZaehler(self):
      """
      /* liefert den Wert des Zhlers
      /* --------------------------------------
      /* Rckgabewert : integer
      """
      return self.zaehler.getWert()

   def getNenner(self):
      """
      /* liefert den Wert des Nenners
      /* --------------------------------------
      /* Rckgabewert : integer
      """
      return self.nenner.getWert()

   def invertieren(self):
      """
      /* vertauscht Zhler und Nenner (Kehrbruch)
      """
      zwi=self.zaehler
      self.zaehler=self.nenner
      self.nenner=zwi

   def erweitern_mit(self,n):
      """
      /* Der Bruch wird mit n erweitert
      /* ---------------------------------------------------
      /* n : integer : Wert, mit dem erweitert werden soll
      """
      self.zaehler.setWert(self.zaehler.getWert()*n)
      self.nenner.setWert(self.nenner.getWert()*n)
      
   def kuerzen_durch(self,n):
      """
      /* Der Bruch wird durch n gekrzt
      /* ---------------------------------------------------
      /* n : integer : Wert, durch den gekrzt werden soll
      """
      if (self.zaehler.getWert()%n==0) and (self.nenner.getWert()%n==0):
         self.zaehler.setWert(self.zaehler.getWert()/n)
         self.nenner.setWert(self.nenner.getWert()/n)
         return 1 # true
      else:
         return 0 # false
      
   def kuerzen(self):
      """
      /* primitiver Algorithmus, der soweit wie mglich krzt
      """
      x=1
      while x:
         N=self.nenner.getWert()
         x=0
         for i in range(2,N+1):
            x = x or self.kuerzen_durch(i)
                                                  

# Testumgebung:

if __name__ == "__main__":
   terminal=XTerm()
   mein_Bruch=Bruch()
   terminal.clear()
   terminal.output("Zhler eingeben: ")
   mein_Bruch.setZaehler(string.atoi(terminal.input()))
   terminal.output("\nNenner eingeben: ")
   mein_Bruch.setNenner(string.atoi(terminal.input()))
   terminal.goto(0,10)
   mein_Bruch.kuerzen()
   terminal.output("\nZhler: "+str(mein_Bruch.getZaehler()))
   terminal.output("\nNenner : "+str(mein_Bruch.getNenner())+"\n")
   mein_Bruch.invertieren()
   terminal.output("\nZhler: "+str(mein_Bruch.getZaehler()))
   terminal.output("\nNenner : "+str(mein_Bruch.getNenner())+"\n")

