#! /usr/bin/python
 
from xterm import * # fr Testumgebung
from bruch import *
import string

class Bruchrechner:
   """
   /* stellet das Fachkonzept fr einen Bruchrechner dar
   """
   def __init__(self):
      """
      /* Attribute sind: Bruch1, Bruch2, Ergebnis, Operator (default: +)
      """
      self.bruch1=Bruch()
      self.bruch2=Bruch()
      self.ergebnis=Bruch()
      self.operator='+'

   def setOperator(self,wert):
      """
      /* Der Operator wird auf eine der Operationen + - * : gesetzt
      /* Es erfolgt noch keine Berechnung
      /* ----------------------------------------------------------
      /* wert : character : gewnschte Operation (ohne Fehlerabfragen)
      """
      self.operator=wert

   def getOperator(self):
      """
      /* liefert die ausgewhlte Operation zurck
      """
      return self.operator

   def setBruch(self,zaehler,nenner,Nr):
      """
      /* Bruch1 oder Bruch2 knnen definiert werden. 
      /* --------------------------------------------
      /* zaehler : integer 
      /* nenner  : integer 
      /* Nr      : integer : 1 oder 2  fr Bruch1 oder Bruch2
      """
      if Nr == 1 :
          self.bruch1.setZaehler(zaehler)
          self.bruch1.setNenner(nenner)
      else:
          self.bruch2.setZaehler(zaehler)
          self.bruch2.setNenner(nenner)
          
   def getBruch(self,Nr):
      """
      /* liefert den Bruch als Zahlenpaar zurck 
      /* -----------------------------------------------
      /* Nr: integer : 1,2 oder 3 fr Ergebnisbruch
      /* -----------------------------------------------
      /* Rckgabe : Paar : (integer,integer)
      """
      if Nr == 1 :
          return self.bruch1.getZaehler(), self.bruch1.getNenner()
      if Nr == 2:
          return self.bruch2.getZaehler(), self.bruch2.getNenner()
      if Nr == 3:
          return self.ergebnis.getZaehler(), self.ergebnis.getNenner()

   def erweitern_mit(self,n):
      """
      /* Bruch1 wird mit n erweitert (monadische Operation)
      /* -----------------------------------------------
      /* n : integer
      """
      self.bruch1.erweitern_mit(n)
      
   def kuerzen(self,Nr):
      """
      /* Bruch1, Bruch2 oder ergebnis werden soweit wie mglich gekrzt
      /* --------------------------------------------------------------
      /* Nr : 1,2 oder 3 fr Ergebnisbruch
      """
      if Nr==1:
         self.bruch1.kuerzen()
      if Nr==2:
         self.bruch2.kuerzen()
      if Nr==3:
         self.ergebnis.kuerzen()

   def berechne(self):
      """
      /* Entsprechend der Operations-Vorwahl wird die Berechnung aus den
      /* beiden Brchen durchgefhrt und als Ergebnisbruch gespeichert.
      /* (diadische Operationen: + - * : ). 
      /* Fehlermeldung, wenn Nenner 0 ber StdIO
      """
      if (self.bruch2.getNenner()==0) or (self.bruch1.getNenner()==0):
            print "Fehler! DIVISION durch 0!"
      else:
         if self.operator=='+':
            n=self.bruch1.getNenner()
            self.bruch1.erweitern_mit(self.bruch2.getNenner())
            self.bruch2.erweitern_mit(n)
            self.ergebnis.setZaehler \
                     (self.bruch1.getZaehler()+self.bruch2.getZaehler())
            self.ergebnis.setNenner(self.bruch1.getNenner())
         if self.operator=='-':
            n=self.bruch1.getNenner()
            self.bruch1.erweitern_mit(self.bruch2.getNenner())
            self.bruch2.erweitern_mit(n)
            self.ergebnis.setZaehler \
                     (self.bruch1.getZaehler()-self.bruch2.getZaehler())
            self.ergebnis.setNenner(self.bruch1.getNenner())
         if self.operator=='*':
            self.ergebnis.setZaehler \
                     (self.bruch1.getZaehler()*self.bruch2.getZaehler())
            self.ergebnis.setNenner \
                     (self.bruch1.getNenner()*self.bruch2.getNenner())
         if self.operator==':':
            if self.bruch2.getZaehler()==0:
               print "Fehler! DIVISION durch 0!"
            else:
               self.bruch2.invertieren()
               self.setOperator('*')
               self.berechne()
         self.kuerzen(3)

# Testumgebung:

if __name__ == "__main__":
   terminal=XTerm()
   terminal.clear()
   terminal.output("Zhler1 eingeben: ")
   z1=string.atoi(terminal.input())
   terminal.output("\nNenner1 eingeben: ")
   n1=string.atoi(terminal.input())
   terminal.output("Zhler2 eingeben: ")
   z2=string.atoi(terminal.input())
   terminal.output("\nNenner2 eingeben: ")
   n2=string.atoi(terminal.input())
   terminal.output("Operation + - * : ")
   o=terminal.input()
   terminal.goto(0,10)

   mB=Bruchrechner()
   mB.setOperator(o[0])
   mB.setBruch(z1,n1,1)
   mB.setBruch(z2,n2,2)
   mB.berechne()

   terminal.output("\nErgebnis: "+str(mB.getBruch(3))+"\n")
