#! /usr/bin/python

import Tkinter
from Tkconstants import *
from bruchrechner import *

class xBruch:
   """
   /* GUI-Darstellung eines Bruches
   """
   def __init__(self,win):
      """
      /* Zwei Eingabefelder werden bereinander angeordnet (Zhler,Nenner).
      /* ------------------------------------------------------------------
      /* win kennzeichnet das Parent-Objekt, in das der Bruch gelegt wird.
      """
      zWert=Tkinter.StringVar()
      self.zaehler=Tkinter.Entry(win,textvariable=zWert, width=5)
      self.zaehler.pack()
      nWert=Tkinter.StringVar()
      self.nenner=Tkinter.Entry(win,textvariable=nWert, width=5)
      self.nenner.pack()

   def getZaehler(self):
      """
      /* liefert den eingegebenen Wert aus dem Zhler-Eingabefeld 
      """
      self.zaehler.selection_range(0,"end") 
      return (self.zaehler.selection_get())
 
   def getNenner(self):
      """
      /* liefert den eingegebenen Wert aus dem Nenner-Eingabefeld 
      """
      self.nenner.selection_range(0,"end") 
      return (self.nenner.selection_get())

   def setZaehler(self,wert):
      """
      /* Vorbesetzung des Zhler-Eingabefeldes mit einem Wert
      """
      self.zaehler.delete(0,"end")
      self.zaehler.insert(0,wert)         

   def setNenner(self,wert):
      """
      /* Vorbesetzung des Nenner-Eingabefeldes mit einem Wert
      """
      self.nenner.delete(0,"end")
      self.nenner.insert(0,wert)         

  
class xTaste:
   """
   /* GUI-Darstellung einer Taste
   """
   def __init__(self, win, Text, Bef, Seite=TOP):
      """
      /* win kennzeichnet das Parent-Objekt, in das die Taste gelegt wird.
      /* Text : string : Beschriftung der Taste
      /* Bef  : Methodenreferenz : Methode, die beim Drcken der Taste 
      /*                           ausgefhrt werden soll.
      /* Seite: opt. Parameter, um Tasten auch nebeneinander anordnen zu knnen
      """
      Knopf=Tkinter.Button(win, text=Text, command=Bef)
      Knopf.pack(side=Seite, padx=5, pady=12) 

class xRechner:
   """
   /* GUI-Darstellung des Rechners
   """
   def __init__(self,Rechner):
      """
      /* Bei der Objekterzeugung wird ein Fenster mit dem Rechner
      /* geffnet
      /* ---------------------------------------------------------
      /* Rechner: Referenz auf ein Objekt der Klasse Bruchrechner
      """
      self.Rechner=Rechner
      win=Tkinter.Tk()
      Fensterbreite=str(450)
      Fensterhoehe=str(350)
      geometrie=Fensterbreite+"x"+Fensterhoehe+"+0+0"
      win.geometry(geometrie)
      win.title("Bruchrechner")

      Rahmen0=Tkinter.Frame(win, relief=SUNKEN, bd=2)
      Rahmen0.pack(padx=5, pady=9) 
      RahmenX=Tkinter.Frame(win, bd=2)
      RahmenX.pack(padx=5, pady=9) 
      Rahmen1=Tkinter.Frame(Rahmen0, relief=SUNKEN, bd=2)
      Rahmen1.pack(side=LEFT, padx=5, pady=9) 
      Rahmen2=Tkinter.Frame(Rahmen0, relief=SUNKEN, bd=2)
      Rahmen2.pack(side=LEFT, padx=5, pady=9) 
      Rahmen3=Tkinter.Frame(Rahmen0, relief=SUNKEN, bd=2)
      Rahmen3.pack(side=LEFT, padx=5, pady=9) 
      Rahmen4=Tkinter.Frame(Rahmen0, relief=SUNKEN, bd=2)
      Rahmen4.pack(side=LEFT, padx=5, pady=9) 
      Rahmen5=Tkinter.Frame(Rahmen0, relief=SUNKEN, bd=2)
      Rahmen5.pack(side=LEFT, padx=5, pady=9) 

      self.B1=xBruch(Rahmen1)
      self.B2=xBruch(Rahmen3)
      self.B3=xBruch(Rahmen5)

      K0=xTaste(Rahmen4,' = ', self.ist)
      K1=xTaste(Rahmen2,' + ', self.plus)
      K2=xTaste(Rahmen2,' - ', self.minus)
      K3=xTaste(Rahmen2,' * ', self.mal)
      K4=xTaste(Rahmen2,' : ', self.geteilt)
      KY=xTaste(RahmenX,' krzen ',self.kuerzen, "left")
      KX=xTaste(RahmenX,' E N D E ', "exit", "left")
      
   def ist(self):
      """
      /* Methode, die beim Drcken der = Taste aufgerufen wird
      """
      print "Methode ist"

   def plus(self):
      """
      /* Methode, die beim Drcken der + Taste aufgerufen wird
      """
      print "Methode plus"

   def minus(self):
      """
      /* Methode, die beim Drcken der - Taste aufgerufen wird
      """
      print "Methode minus"

   def mal(self):
      """
      /* Methode, die beim Drcken der * Taste aufgerufen wird
      """
      print "Methode mal"

   def geteilt(self):
      """
      /* Methode, die beim Drcken der : Taste aufgerufen wird
      """
      print "Methode geteilt"

   def kuerzen(self):
      """
      /* Methode, die beim Drcken der Krzen-Taste aufgerufen wird
      """
      print "Methode kuerzen"
      
if __name__ == "__main__":
   mRechner=Bruchrechner()
   mWindow=xRechner(mRechner)
   Tkinter.mainloop()
