#!/usr/bin/python

from Tkconstants import *
import os
import string
import sys
from datwahlfenster import *
from meldung import *

class BenutzerInterface:
   """
   /* Erzeugt ein Fenster auf dem Bildschirm mit Pull-Down-Menue
   """
   def __init__(self):
     """
     * Initialisierung
     """
     self.eineDateiauswahl=None   # Referenz auf Dateiauswahl
     self.tk=Tkinter.Tk()  # s. Tk-Inter
     self.__Fenster_zeigen()
     self.__Menu_zeigen()
     self.datei=""    # aktuell ausgewhlte Datei : keine
     self.verz=os.getcwd()  # aktuelles Verzeichnis holen
     self.demoObj=[1,2,3] # das ist mein zu speicherndes Objekt  # demo-Objekt

   def __Fenster_zeigen(self):
     """
     /* interne Methode, Verfeinerung, spricht fr sich selbst
     """
     Fensterbreite=str(450)
     Fensterhoehe=str(350)
     geometrie=Fensterbreite+"x"+Fensterhoehe+"+0+0"
     self.tk.geometry(geometrie)
     self.tk.title("Beispiel fr die Anwendung des Dateiwahlfensters")

   def __Menu_zeigen(self):
     """
     /* interne Methode: Generierung des Pull-Down-Menues
     """
     zeile=Tkinter.Frame(self.tk,relief=RAISED, bd=2)
     zeile.pack(side=TOP, fill=X)
     fileButton=Tkinter.Menubutton(zeile,text="  Datei  ",underline=2)
     fileButton.pack(side=LEFT)
     DateiMenu=Tkinter.Menu(fileButton)
     DateiMenu.add_command(label="Neu", command=self.neu)      
     DateiMenu.add_command(label="ffnen", command=self.oeffnen)
     DateiMenu.add_separator()                                                  
     DateiMenu.add_command(label="speichern", command=self.speichern)
     DateiMenu.add_command(label="speichern als ...",command=self.speichern_als)
     DateiMenu.add_separator()
     DateiMenu.add_command(label="Ende", command="exit")
     fileButton["menu"]=DateiMenu

   def neu(self): 
     """
     /* neues demo-Objekt erzeugen
     """
     del self.demoObj
     self.demoObj=[]
     print self.demoObj   #  demo

   def __hole(self):   
     """
     /* Beispiel fr interne Lesemethode
     """
     self.verz=self.eineDateiauswahl.get_dir() 
     self.datei=self.eineDateiauswahl.get_datei()
     fname=self.verz+os.sep+self.datei  # akt. Dateiname
     try:
        f=open(fname,"r")
        objekt=pickle.load(f)
        f.close()
        self.demoObj=objekt
        self.eineDateiauswahl.set_fertig()
     except:
        meldung=Meldung("Datei oder Verzeichnis nicht gefunden!")
        self.eineDateiauswahl.set_datei=""
     print self.demoObj   #  demo
                                       
   def oeffnen(self):
     """
     /* Objekterzeugung: Fachkonzept und GUI Dateiauswahl
     """
     self.eineDateiauswahl=DV_Auswahl(self.__hole,"*.list") 
     einDateiauswahlFenster=DV_Auswahl_GUI("   ffnen   ",self.eineDateiauswahl)
     # GUI kennt Fachkonzept (self.eineDateiauswahl)

   def speichern(self):
     """
     /* falls noch keine Dateiauswahl erfolgte: speichern_als!
     """
     if self.eineDateiauswahl != None:
         self.datei=self.eineDateiauswahl.get_datei()
         self.verz=self.eineDateiauswahl.get_dir()
     if self.datei=="":
         self.speichern_als()
     else:
         try:
            fname=self.verz+os.sep+self.datei
            f=open(fname,"w")
            pickle.dump(self.demoObj,f)
            f.close()                     
            self.eineDateiauswahl.set_fertig()
            print self.demoObj   #  demo
         except:
            meldung=Meldung("Schreibfehler! Keine Berechtigung!")
            self.eineDateiauswahl.set_datei=""

   def speichern_als(self):
       """
       /* Objekterzeugung: Fachkonzept und GUI Dateiauswahl
       """
       self.eineDateiauswahl=DV_Auswahl(self.__speichern2,"*.list") 
                                                   # Schreibmethode bergeben
       einDateiauswahlFenster=DV_Auswahl_GUI("  speichern  " \
                                                      ,self.eineDateiauswahl)
       # Fachkonzept muss GUI bekannt sein

   def __speichern2(self): 
       """
       /* Beispiel fr interne Schreibmethode
       """
       self.datei=self.eineDateiauswahl.get_dir()
       self.verz=self.eineDateiauswahl.get_datei()
       fname=self.datei+os.sep+self.verz  # Dateiname
       try:
          f=open(fname,"w")
          pickle.dump(self.demoObj,f)
          f.close()                                                         
          self.eineDateiauswahl.set_fertig()
          print self.demoObj   #  demo
       except:
          meldung=Meldung("Schreibfehler! Keine Berechtigung!")
          self.eineDateiauswahl.set_datei=""


#--------------------------   Hauptprogramm  ---------------------------

MeinBildschirm=BenutzerInterface()
Tkinter.mainloop() 
