#! /usr/bin/python

import math

class Register:
   """
   /* Realisiert einen Speicherplatz fr eine REAL-Zahl
   """
   def __init__(self):
      """
      /* Kommentar
      """
      self.Wert=0.0

   def set(self,Zahl):
      """
      /* Schreibt eine Zahl in den Speicherplatz
      """
      self.Wert=Zahl

   def get(self):
      """
      /* Fragt den Zahlenwert im Speicher ab
      """
      return(self.Wert)


class Stapel:
   """
   /* Realisiert einen Stapel aus 4 Registern bestehend. Als
   /* Methoden werden reine Stapeloperatinen implementiert.
   /* Die Register heissen  X , Y , Z , T
   /* Die Methoden sind in Anlehnung an die Programmiersprache FORTH
   /* benannt.
   """
   def __init__(self):
      """
      /* Kommentar
      """
      self.X=Register()
      self.Y=Register()
      self.Z=Register()
      self.T=Register()

   def dup(self):
      """
      /* alle Registerinhalte werden um 1 Register nach unten geschoben,
      /* der Inhalt von X bleibt erhalten (in y liegt ein Duplikat)
      """
      self.T.set(self.Z.get())
      self.Z.set(self.Y.get())
      self.Y.set(self.X.get())

   def drop(self):
      """
      /* alle Registerinhalte werden um 1 Register nach oben geschoben,
      /* der Inhalt von T bleibt erhalten, der Inhalt von X geht verloren.
      """
      self.X.set(self.Y.get())
      self.Y.set(self.Z.get())
      self.Z.set(self.T.get())

   def swap(self):
      """
      /* Die Inhalte der Register X und Y werden vertauscht.
      """
      x=self.X.get()
      self.X.set(self.Y.get())
      self.Y.set(x)

   def rotate(self):
      """
      /* Die Inhalte der Register werden nach oben verschoben, der 
      /* Inhalt des Registers X wird nach T transferiert.
      """
      x=self.X.get()
      self.drop()
      self.T.set(x)

   def output(self):
      """
      /* Der Inhalt des X-Registers wird zurckgegeben, alle Registerinhalte
      /* wandern im Stapel um 1 nach oben (der Inhalt von T bleibt erhalten).
      """
      x=self.getX()
      self.drop()
      return x

   def input(self,Zahl):
      """
      /* Alle Stapelinhalte wandern nach unten, Zahl wird in das X-Register
      /* geschrieben.
      """
      self.dup()
      self.setX(Zahl)
   
   def getX(self):
      """
      /* Liefert den aktuellen X-Wert (keine Stapelbewegungen)
      """
      return self.X.get()

   def setX(self,Wert):
      """
      /* Ersetzt den aktuellen X-Wert, ohne dass Stapelbewegungen erfolgen.
      """
      self.X.set(Wert)

class Rechner(Stapel):
   """
   /* Kommentar
   """
   def __init__(self):
      """
      /* Der Rechner besteht im Wesentlichen aus einem Stapel mit zustzlichen
      /* Rechenmethoden. Er erbt deshalb von Stapel. Hier wird fr jede Taste
      /* eine entsprechende Methode deklariert.
      """
      Stapel.__init__(self)
      self.Memory = 0.0
      self.Fehler = 0

   def get_Fehler(self):
      return self.Fehler
 
   def clear_Fehler(self):
      self.Fehler=0

   def addieren(self):
      """
      /* X wird X+Y
      """
      self.input(self.output() + self.output())

   def subtrahieren(self):
      """
      /* X wird Y-X
      """
      self.swap()
      self.input(self.output() -  self.output())

   def multiplizieren(self):
      """
      /* X wird X*Y
      """
      self.input(self.output() * self.output())

   def dividieren(self):
      """
      /* X wird X:Y
      """
      self.swap()
      try:
         self.input(self.output() / self.output())
      except:
         self.Fehler=1

   def radizieren(self):
      """
      /* X wird  SQRT(X)
      """
      self.setX(math.sqrt(self.getX()))

   def invertieren(self):
      """
      /* X wird 1:X
      """
      try:
         self.setX(1.0 / self.getX())
      except:
         self.Fehler=1

   def speichern(self):
      self.Memory=getX()

   def zurueckholen(self):
      self.input(self.Memory)

   def pi_eingeben(self):
      self.input(math.pi)

   def potenziere(self):
      self.input(pow(self.output(),self.output()))

   def logarithmiere(self):
      self.input(log10(self.output()))

   def lognat(self):
      self.input(log(self.output()))

   def power_e(self):
      try:
         self.input(pow(math.e,self.output()))
      except:
         self.Fehler=1

   def sinus(self):
      self.input(math.sin(self.output()))

   def cosinus(self):
      self.input(math.cos(self.output()))

   def tangens(self):
      self.input(math.tan(self.output()))

   def arcsinus(self):
      self.input(math.asin(self.output()))

   def arccosinus(self):
      self.input(math.acos(self.output()))

   def arctangens(self):
      self.input(math.atan(self.output()))

   def chs(self):
      self.input(-1.0*self.output())

   def loeschen(self):
      """
      /* X wird 0
      """
      self.setX(0.0)

   def alles_loeschen(self):
      self.loeschen()
      for i in [1,2,3]:
         self.dup()


