#! /usr/bin/python

import sys
import posix

class XTerm:
   """
   /* Bildschirmsteuerung nach ansi fr linux-console !
   /* Es muss das Programm  init_term  im Suchpfad fr Programme
   /* enthalten sein!
   /* Quelltext:  (Datei   init_term.c)
   /*
   /* #include <curses.h> 
   /*
   /* main ()
   /*    {
   /*      initscr(); 
   /*      endwin();
   /*    }
   /*
   /* bersetzung mit 
   /*          cc -o init_term init_term.c -lncurses 
   """
   def __init__(self):
      """
      /* Es stehen folgende Farbnamen (strings) zur Verfgung:
      /*    schwarz, rot, grn, gelb, blau, magenta, cyan, wei
      /* Es stehen folgende Attribute zur Verfgung:
      /*    aus, fett, blink, invers
      """
      self.farbe = {
                      "schwarz":0,
                      "rot":1,
                      "grn":2,
                      "gelb":3,
                      "blau":4,
                      "magenta":5,
                      "cyan":6,
                      "wei":7
                   }

      self.attr =  {
                      "aus":0,
                      "fett":1,
                      "blink":5,
                      "invers":7
                    }

      self.x=0
      self.y=0
      self.xr1=0
      self.yr1=0
      self.xr2=0
      self.yr2=0

      posix.system("init_term")


   def __color(self,n):
      x="%i" % (n)
      self.output(chr(27)+"["+x+"m")
 
   def output(self,t):
      """ 
      /* schreibt auf den Bildschirm
      /* -----------------------------
      /* t : string :  auszugebender Text
      """
      sys.stdout.write(t)

   def clear(self):
      """
      /* lscht den Bildschirm
      """
      self.output(chr(27)+"[2J")
      self.goto(0,0)

   def goto(self,x,y):
      """
      /* positioniert den Cursor relativ zur linken oberen Ecke (0,0)
      /* ------------------------------------------------------------
      /* x : int : Spaltenposition
      /* y : int : Zeilenposition
      """
      self.x=x
      x1="%i" % (x+1)
      self.y=y
      y1="%i" % (y+1)
      self.output(chr(27)+"["+y1+";"+x1+"H")  
 
   def setForeground(self,farbe):
      """
      /* setzt Zeichenfarbe
      /* ---------------------------------------------
      /* farbe : string : Farbwerte : siehe oben
      """
      self.__color(self.farbe[farbe]+30)
      
   def setBackground(self,farbe):
      """
      /* setzt Hintergrundfarbe
      /* ---------------------------------------------
      /* farbe : string : Farbwerte : siehe oben
      """
      self.__color(self.farbe[farbe]+40)
      
   def setAttribute(self,wert):
      """
      /* setzt Schreibattribute
      /* ---------------------------------------------
      /* wert : string : Attributwerte : siehe oben
      """
      self.__color(self.attr[wert])

   def normVideo(self):
      """
      /* setzt Ausgabeparameter auf schwarz auf weiss, Attribute aus
      """
      self.setForeground("wei")
      self.setBackground("schwarz")
      self.setAttribute("aus")

   def horLine(self,b):
      """
      /* zeichnet eine horizontale Linie
      /* -----------------------------------
      /* b : int : Lnge der Linie in Zeichen
      """
      self.output(chr(14))
      for i in range(0,b):
         self.output(chr(113))
      self.output(chr(15))

   def vertLine(self,h):
      """
      /* zeichnet eine vertikale Linie
      /* -----------------------------------
      /* h : int : Lnge der Linie in Zeichen
      """
      self.output(chr(14))
      for i in range(0,h):
         self.output(chr(120))
         self.output(chr(27)+"[B")
         self.output(chr(27)+"[D")
      self.output(chr(15))

   def horELine(self,b):
      """
      /* zeichnet eine horizontale Linie mit Abschlu-Ts
      /* ----------------------------------------------
      /* b : int : Lnge der Linie in Zeichen
      """
      self.output(chr(14))
      self.output(chr(116))
      for i in range(1,b-1):
         self.output(chr(113))
      self.output(chr(117))
      self.output(chr(15))

   def vertELine(self,h):
      """
      /* zeichnet eine vertikale Linie mit Abschlu-Ts
      /* ------------------------------------------------
      /* h : int : Lnge der Linie in Zeichen
      """
      self.output(chr(14))
      self.output(chr(119))
      self.output(chr(27)+"[B")
      self.output(chr(27)+"[D")
      for i in range(1,h-1):
         self.output(chr(120))
         self.output(chr(27)+"[B")
         self.output(chr(27)+"[D")
      self.output(chr(118))
      self.output(chr(15))

   def Rahmen(self,b,h):
      """
      /* zeichnet einen Rahmen
      /* ------------------------------------------------
      /* b : int : Breite des Rechtecks
      /* h : int : Hhe des Rechtecks
      """
      self.xr1=self.x
      self.yr1=self.y
      self.xr2=self.x+b-1
      self.yr2=self.y+h-1
      self.output(chr(14))
      self.output(chr(108))
      self.output(chr(15))
      self.horLine(b-2)
      self.output(chr(14))
      self.output(chr(107))
      self.output(chr(15))
      self.goto(self.xr2,self.yr1+1)
      self.vertLine(h-2)
      self.goto(self.xr1,self.yr1+1)
      self.vertLine(h-2)
      self.goto(self.xr1,self.yr2)
      self.output(chr(14))
      self.output(chr(109))
      self.output(chr(15))
      self.horLine(b-2)
      self.output(chr(14))
      self.output(chr(106))
      self.output(chr(15))

   def input(self):
      """
      /* liest eine Eingabe gepuffert ein
      /* --------------------------------------
      /* --------------------------------------
      /* return : string : Eingabezeile
      """
      return sys.stdin.readline()
#     geht das auch mit raw_input?


# Testumgebung

if __name__ == "__main__":
   screen = X_Term()
   screen.setForeground("blau")
   screen.setBackground("cyan")
   screen.clear()
   screen.goto(10,5)
   screen.Rahmen(60,10)
   screen.goto(15,10)
   screen.output("Eingabe: ")
   screen.setForeground("wei")
   x=screen.input()
   screen.setForeground("blau")
   screen.goto(0,21)
   screen.output(x)
   

