#! /usr/bin/python
import Tkinter 
import os
from Tkconstants import *

class EingabeZeile:
   """
   /* Widget-Kombination aus Label und Entry:
   /* links BER der Eingabezeile steht die Beschriftung
   """

   def __init__(self,oWindow, Beschriftung, Laenge, Aktion):
      """
      /* oWindow:         Tk: Objekt Elternfenster 
      /* Beschriftung:    String: Text fr Label
      /* Laenge:          Int: maximale Entry-Lnge (in Zeichen)
      /* Aktion:          Referenz auf Ereignismethode (Returntaste)
      """
      oLabel=Tkinter.Label(oWindow, text=Beschriftung)
      oLabel.pack(padx=5, pady=5, anchor=W)
      self.oEingabe=Tkinter.Entry(oWindow, width=Laenge, font="*-140-*")
      self.oEingabe.pack(fill=X, padx=5, pady=5) 
      self.oEingabe.bind("<Return>",Aktion)

   def getZeile(self):
      """
      /* liefert den Eingabe-String zurck
      """
      try:
         self.oEingabe.selection_range(0,"end")
         return self.oEingabe.selection_get()
      except:
         return ""

   def setZeile(self,Inhalt):
      """
      /* Inhalt:    string: Textvorgabe fr das Eingabefenster
      """
      self.oEingabe.delete(0,"end")
      self.oEingabe.insert(0,Inhalt)

class DreiKnoepfe:
   """
   /* Widget-Kombination dreier Buttons, die am unteren Rand
   /* des Elternfensters nebeneinander liegen, der erste
   /* Knopf ist hervorgehoben
   """

   def __init__(self,oWindow,Text1, Text2, Text3, A1, A2, A3):
      """
      /* oWindow:                Tk: Objekt Elternfenster 
      /* Text1, Text2, Text3:    String: Beschriftung der Knpfe
      /* A1, A2, A3: Referenz auf die Ereignismethoden (linke Maus-Taste)
      """
      oRahmen=Tkinter.Frame(oWindow, relief=SUNKEN, bd=2)
      oRahmen.pack(side=LEFT, padx=5, pady=9, anchor=S)
      oKnopf=Tkinter.Button(oRahmen,text=Text1, command=A1)
      oKnopf.pack(padx=2, pady=2)                       
      # Knpfe 2 und 3:
      oKnopf=Tkinter.Button(oWindow, text=Text3, command=A3)
      oKnopf.pack(side=RIGHT, padx=5, pady=12, anchor=S)
      oKnopf=Tkinter.Button(oWindow, text=Text2, command=A2)
      oKnopf.pack(side=RIGHT, padx=20, pady=12, anchor=S)

class Listbox_mit_Schiebern:
   """
   /* Widget-Kombination aus Listbox und vertikalem
   /* sowie horizontalem Scrollbar. Links oberhalb
   /* der Listbox ist eine Beschriftung angebracht
   """

   def __init__(self,oWindow,Beschriftung, aktion1, aktion2):
      """
      /* oWindow:           Tk: Objekt Elternfenster 
      /* Beschriftung       String: Beschriftung 
      /* aktion1            Referenz auf Methode bei Einfachklick
      /* aktion2            Referenz auf Methode bei Doppelklick
      """
      oLabel=Tkinter.Label(oWindow, text=Beschriftung)
      oLabel.pack(padx=5, pady=2, anchor=W)
      oHoriscroll=Tkinter.Scrollbar(oWindow, orient=HORIZONTAL)
      oHoriscroll.pack(fill=X,side=BOTTOM)
      self.oListen_box=Tkinter.Listbox(oWindow)
      self.oListen_box.pack(expand=1,side="left",fill=BOTH)
      oVertikalscroll=Tkinter.Scrollbar(oWindow, orient=VERTICAL)
      oVertikalscroll.pack(side="right", fill=Y)
      # Kopplung Scrollbars an Liste und umgekehrt
      oHoriscroll.config(command=self.oListen_box.xview)
      oVertikalscroll.config(command=self.oListen_box.yview)
      self.oListen_box.config(xscrollcommand=oHoriscroll.set, \
                                   yscrollcommand=oVertikalscroll.set)
      self.oListen_box.bind("<ButtonRelease-1>", aktion1)
      self.oListen_box.bind("<Double-Button-1>", aktion2)

   def liste_uebergeben(self,liste):
      """
      /* liste : Liste mit Dateinamen (Strings), die in Listbox angezeigt
      /*         werden soll.
      """
      liste.sort()
      self.oListen_box.delete(0,"end")
      for name in liste:
         self.oListen_box.insert("end",name)
      
   def get_Auswahl(self):
      """
      /* liste : Inhalt einer Zeile der Listbox, die mit der Maus
      /*         selektiert wurde 
      """
      return self.oListen_box.selection_get()

class Listbox_mit_Schiebern2(Listbox_mit_Schiebern):
   """
   /* Widget-Kombination aus Listbox und vertikalem
   /* sowie horizontalem Scrollbar. Links oberhalb
   /* der Listbox ist eine Beschriftung angebracht
   /* Variante der Listbox_mit_Schiebern (Erbschaft)!!!
   /* Im Gegensatz zur ersten Version hat diese Listbox ein
   /* Gedchtnis und merkt sich den selektierten Eintrag, um
   /* ihn nach der Aktion noch als markiert anzuzeigen. Diese
   /* Eigenschaft ist im linken Fenster berflssig und strend,
   /* falls nach dem cd ein Verzeichnis mit gleichem Namen vorkommt.
   """

   def __init__(self,oWindow,Beschriftung, aktion1, aktion2):
      """
      /* oWindow:           Tk: Objekt Elternfenster 
      /* Beschriftung       String: Beschriftung 
      /* aktion1            Referenz auf Methode bei Einfachklick
      /* aktion2            Referenz auf Methode bei Doppelklick
      """
      oLabel=Tkinter.Label(oWindow, text=Beschriftung)
      Listbox_mit_Schiebern.__init__(self,oWindow,Beschriftung,aktion1,aktion2)
      self.Gedaechtnis=""

   def liste_uebergeben(self,liste):
      """
      /* liste : Liste mit Dateinamen (Strings), die angezeigt werden
      /*         soll. Gemerkter Dateiname wird in Liste gesucht und
      /*         Eintrag mit entsprechendem Index markiert. (Zuvor wird
      /*         der Index bestimmt.)
      """
      liste.sort()
      self.oListen_box.delete(0,"end")
      counter=-1
      index1=counter
      for name in liste:
         self.oListen_box.insert("end",name)
         counter=counter+1
         if name==self.Gedaechtnis:
            index1=counter
      if (index1 > -1):
         self.oListen_box.select_set(index1)
         self.oListen_box.see(index1)
 
   def get_Auswahl(self):
      """
      /*  Markierter Dateiname wird gemerkt und zurckgegeben
      """
      self.Gedaechtnis=self.oListen_box.selection_get()
      return self.Gedaechtnis

if __name__ == "__main__":
   # Testprogramm - wird nur beim Aufruf von tool1.py von der Systemebene
   # aus aufgefhrt!
   #
   # Hauptfenster erzeugen:
   oWindow=Tkinter.Tk()
   # Testen einzelner Klassen (s.o.)
   oZeile=EingabeZeile(oWindow,"Return in Zeile beendet!",20,"exit")
   oListe=Listbox_mit_Schiebern(oWindow,"Klick im Feld beendet!","exit","exit")
   Tkinter.mainloop()      
